'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTagPickerControl_unstable", {
    enumerable: true,
    get: function() {
        return useTagPickerControl_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _TagPickerContext = require("../../contexts/TagPickerContext");
const _reacticons = require("@fluentui/react-icons");
const _useResizeObserverRef = require("../../utils/useResizeObserverRef");
const _useTagPickerControlStylesstyles = require("./useTagPickerControlStyles.styles");
const _reactfield = require("@fluentui/react-field");
const _useExpandLabel = require("../../utils/useExpandLabel");
const useTagPickerControl_unstable = (props, ref)=>{
    var _useFieldContext_unstable;
    const targetRef = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.targetRef);
    const triggerRef = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.triggerRef);
    const tagPickerGroupRef = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.tagPickerGroupRef);
    const open = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.open);
    const popoverId = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.popoverId);
    const setOpen = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.setOpen);
    const secondaryInnerActionRef = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.secondaryActionRef);
    const size = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.size);
    const appearance = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.appearance);
    const disabled = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.disabled);
    const invalid = ((_useFieldContext_unstable = (0, _reactfield.useFieldContext_unstable)()) === null || _useFieldContext_unstable === void 0 ? void 0 : _useFieldContext_unstable.validationState) === 'error';
    const noPopover = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>{
        var _ctx_noPopover;
        return (_ctx_noPopover = ctx.noPopover) !== null && _ctx_noPopover !== void 0 ? _ctx_noPopover : false;
    });
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const tagPickerId = (0, _reactutilities.useId)('tagPicker-');
    const rafIdRef = _react.useRef(null);
    const innerRef = _react.useRef(null);
    const expandIconRef = _react.useRef(null);
    const asideRef = _react.useRef(null);
    const secondaryAction = _reactutilities.slot.optional(props.secondaryAction, {
        elementType: 'span'
    });
    const secondaryActionRef = (0, _reactutilities.useMergedRefs)(secondaryInnerActionRef, secondaryAction === null || secondaryAction === void 0 ? void 0 : secondaryAction.ref);
    if (secondaryAction) {
        secondaryAction.ref = secondaryActionRef;
    }
    const expandIcon = _reactutilities.slot.optional(props.expandIcon, {
        renderByDefault: !noPopover,
        defaultProps: {
            'aria-expanded': open,
            'aria-disabled': disabled ? 'true' : undefined,
            children: /*#__PURE__*/ _react.createElement(_reacticons.ChevronDownRegular, null),
            role: 'button'
        },
        elementType: 'span'
    });
    const expandIconMergeRef = (0, _reactutilities.useMergedRefs)(expandIcon === null || expandIcon === void 0 ? void 0 : expandIcon.ref, expandIconRef);
    if (expandIcon) {
        expandIcon.ref = expandIconMergeRef;
    }
    const observerRef = (0, _useResizeObserverRef.useResizeObserverRef)(([entry])=>{
        const targetWindow = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
        if (targetWindow) {
            rafIdRef.current = targetWindow.requestAnimationFrame(()=>{
                var _innerRef_current;
                (_innerRef_current = innerRef.current) === null || _innerRef_current === void 0 ? void 0 : _innerRef_current.style.setProperty(_useTagPickerControlStylesstyles.tagPickerControlAsideWidthToken, `${entry.contentRect.width}px`);
            });
        }
    });
    const aside = _reactutilities.slot.optional(undefined, {
        elementType: 'span',
        renderByDefault: Boolean(secondaryAction || expandIcon),
        defaultProps: {
            ref: observerRef
        }
    });
    const mergedAsideRefs = (0, _reactutilities.useMergedRefs)(asideRef, aside === null || aside === void 0 ? void 0 : aside.ref);
    if (aside) {
        aside.ref = mergedAsideRefs;
    }
    const handleMouseDown = (0, _reactutilities.useEventCallback)((event)=>{
        if (event.isDefaultPrevented()) {
            return;
        }
        if ((0, _reactutilities.elementContains)(expandIconRef.current, event.target) || event.target === innerRef.current || event.target === tagPickerGroupRef.current || event.target === asideRef.current) {
            var _triggerRef_current;
            event.preventDefault();
            setOpen(event, !open);
            (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.focus();
        }
    });
    const state = {
        components: {
            root: 'div',
            expandIcon: 'span',
            secondaryAction: 'span',
            aside: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref: (0, _reactutilities.useMergedRefs)(ref, targetRef, innerRef),
            'aria-owns': open && !noPopover ? popoverId : undefined,
            ...props,
            onMouseDown: handleMouseDown
        }), {
            elementType: 'div'
        }),
        aside,
        expandIcon,
        secondaryAction,
        size,
        appearance,
        disabled,
        invalid
    };
    const expandIconLabelRef = (0, _useExpandLabel.useExpandLabel)({
        tagPickerId,
        state: state
    });
    const expandIconLabelMergeRef = (0, _reactutilities.useMergedRefs)(expandIcon === null || expandIcon === void 0 ? void 0 : expandIcon.ref, expandIconLabelRef);
    if (state.expandIcon) {
        state.expandIcon.ref = expandIconLabelMergeRef;
    }
    _react.useEffect(()=>{
        if (rafIdRef.current && (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView)) {
            targetDocument.defaultView.cancelAnimationFrame(rafIdRef.current);
        }
    }, [
        targetDocument
    ]);
    return state;
};
