'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tagPickerButtonClassNames: function() {
        return tagPickerButtonClassNames;
    },
    useTagPickerButtonStyles_unstable: function() {
        return useTagPickerButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const tagPickerButtonClassNames = {
    root: 'fui-TagPickerButton'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    button: {
        alignItems: 'center',
        minHeight: '32px',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        border: 'none',
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorNeutralForeground1,
        columnGap: _reacttheme.tokens.spacingHorizontalXXS,
        cursor: 'pointer',
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        textAlign: 'left',
        flexGrow: 1,
        '&:focus': {
            outlineStyle: 'none'
        }
    },
    placeholder: {
        color: _reacttheme.tokens.colorNeutralForeground4
    },
    // size variants
    medium: {
        ..._reacttheme.typographyStyles.caption1,
        padding: `3px ${_reacttheme.tokens.spacingHorizontalSNudge} 3px ${`calc(${_reacttheme.tokens.spacingHorizontalSNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`}`
    },
    large: {
        ..._reacttheme.typographyStyles.body1,
        padding: `5px ${_reacttheme.tokens.spacingHorizontalMNudge} 5px ${`calc(${_reacttheme.tokens.spacingHorizontalMNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`}`
    },
    'extra-large': {
        columnGap: _reacttheme.tokens.spacingHorizontalSNudge,
        ..._reacttheme.typographyStyles.body2,
        padding: `7px ${_reacttheme.tokens.spacingHorizontalM} 7px ${`calc(${_reacttheme.tokens.spacingHorizontalM} + ${_reacttheme.tokens.spacingHorizontalSNudge})`}`
    },
    // appearance variants
    outline: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1}`,
        borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
    },
    outlineInteractive: {
        '&:hover': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Hover),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
        },
        '&:active': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
        }
    },
    underline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        borderBottom: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStrokeAccessible}`,
        borderRadius: '0'
    },
    'filled-lighter': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid transparent`
    },
    'filled-darker': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        border: `${_reacttheme.tokens.strokeWidthThin} solid transparent`
    },
    invalid: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder2)
        }
    },
    invalidUnderline: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            borderBottomColor: _reacttheme.tokens.colorPaletteRedBorder2
        }
    },
    disabled: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
        '@media (forced-colors: active)': {
            ..._react.shorthands.borderColor('GrayText')
        }
    },
    disabledText: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        cursor: 'not-allowed'
    },
    hidden: {
        display: 'none'
    },
    visuallyHidden: {
        clip: 'rect(0px, 0px, 0px, 0px)',
        height: '1px',
        margin: '-1px',
        overflow: 'hidden',
        padding: '0px',
        width: '1px',
        position: 'absolute'
    }
});
const useTagPickerButtonStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(tagPickerButtonClassNames.root, styles.button, styles[state.size], state.hasSelectedOption && styles.visuallyHidden, state.root.className);
    return state;
};
