'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTagPickerButton_unstable", {
    enumerable: true,
    get: function() {
        return useTagPickerButton_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactaria = require("@fluentui/react-aria");
const _TagPickerContext = require("../../contexts/TagPickerContext");
const _reactcombobox = require("@fluentui/react-combobox");
const useTagPickerButton_unstable = (props, ref)=>{
    const { controller: activeDescendantController } = (0, _reactaria.useActiveDescendantContext)();
    const triggerRef = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.triggerRef);
    const open = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.open);
    const value = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.value);
    const hasSelectedOption = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.selectedOptions.length > 0);
    const popoverId = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.popoverId);
    const getOptionById = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.getOptionById);
    const selectOption = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.selectOption);
    const setHasFocus = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.setHasFocus);
    const setOpen = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.setOpen);
    // casting is required here as triggerRef can either be button or input,
    // but in this case we can assure it's a button
    const root = (0, _reactcombobox.useButtonTriggerSlot)(props, triggerRef, {
        activeDescendantController,
        defaultProps: {
            type: 'button',
            tabIndex: 0,
            children: value || // @ts-expect-error - FIXME: TS2339: Property 'placeholder' does not exist on type 'TagPickerButtonProps'
            props.placeholder,
            'aria-controls': open ? popoverId : undefined,
            ref
        },
        state: {
            getOptionById,
            open,
            selectOption,
            setHasFocus,
            setOpen,
            multiselect: true
        }
    });
    const size = (0, _TagPickerContext.useTagPickerContext_unstable)((ctx)=>ctx.size);
    const state = {
        components: {
            root: 'button'
        },
        root,
        size,
        hasSelectedOption
    };
    return state;
};
