'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTagPicker_unstable", {
    enumerable: true,
    get: function() {
        return useTagPicker_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactcombobox = require("@fluentui/react-combobox");
const _reactpositioning = require("@fluentui/react-positioning");
const _reactaria = require("@fluentui/react-aria");
// Set a default set of fallback positions to try if the dropdown does not fit on screen
const fallbackPositions = [
    'above',
    'after',
    'after-top',
    'before',
    'before-top'
];
const useTagPicker_unstable = (props)=>{
    const popoverId = (0, _reactutilities.useId)('picker-listbox');
    const triggerInnerRef = _react.useRef(null);
    const secondaryActionRef = _react.useRef(null);
    const tagPickerGroupRef = _react.useRef(null);
    const { positioning, size = 'medium', inline = false, noPopover = false } = props;
    const { targetRef, containerRef } = (0, _reactpositioning.usePositioning)({
        position: 'below',
        align: 'start',
        offset: {
            crossAxis: 0,
            mainAxis: 2
        },
        fallbackPositions,
        matchTargetSize: 'width',
        ...(0, _reactpositioning.resolvePositioningShorthand)(positioning)
    });
    const { controller: activeDescendantController, activeParentRef, listboxRef } = (0, _reactaria.useActiveDescendant)({
        matchOption: (el)=>el.classList.contains(_reactcombobox.optionClassNames.root)
    });
    const comboboxState = (0, _reactcombobox.useComboboxBaseState)({
        ...props,
        onOptionSelect: (0, _reactutilities.useEventCallback)((event, data)=>{
            var _props_onOptionSelect;
            return (_props_onOptionSelect = props.onOptionSelect) === null || _props_onOptionSelect === void 0 ? void 0 : _props_onOptionSelect.call(props, event, {
                selectedOptions: data.selectedOptions,
                value: data.optionValue,
                type: event.type,
                event
            });
        }),
        onOpenChange: (0, _reactutilities.useEventCallback)((event, data)=>{
            var _props_onOpenChange;
            return (_props_onOpenChange = props.onOpenChange) === null || _props_onOpenChange === void 0 ? void 0 : _props_onOpenChange.call(props, event, {
                ...data,
                type: event.type,
                event
            });
        }),
        activeDescendantController,
        editable: true,
        multiselect: true,
        size: 'medium'
    });
    const { trigger, popover } = childrenToTriggerAndPopover(props.children, noPopover);
    return {
        activeDescendantController,
        components: {},
        trigger,
        popover: comboboxState.open || comboboxState.hasFocus ? popover : undefined,
        popoverId,
        noPopover,
        disabled: comboboxState.disabled,
        triggerRef: (0, _reactutilities.useMergedRefs)(triggerInnerRef, activeParentRef),
        popoverRef: (0, _reactutilities.useMergedRefs)(listboxRef, containerRef),
        secondaryActionRef,
        tagPickerGroupRef,
        targetRef,
        size,
        inline,
        open: comboboxState.open,
        mountNode: comboboxState.mountNode,
        onOptionClick: (0, _reactutilities.useEventCallback)((event)=>{
            comboboxState.onOptionClick(event);
            comboboxState.setOpen(event, false);
        }),
        appearance: comboboxState.appearance,
        clearSelection: comboboxState.clearSelection,
        getOptionById: comboboxState.getOptionById,
        getOptionsMatchingValue: comboboxState.getOptionsMatchingValue,
        registerOption: comboboxState.registerOption,
        selectedOptions: comboboxState.selectedOptions,
        selectOption: (0, _reactutilities.useEventCallback)((event, data)=>{
            // if the option is already selected, invoke onOptionSelect callback with current selected values
            // the combobox state would unselect the option, which is not the behavior expected
            if (comboboxState.selectedOptions.includes(data.value) && !(0, _reactutilities.elementContains)(tagPickerGroupRef.current, event.target)) {
                var _props_onOptionSelect;
                (_props_onOptionSelect = props.onOptionSelect) === null || _props_onOptionSelect === void 0 ? void 0 : _props_onOptionSelect.call(props, event, {
                    selectedOptions: comboboxState.selectedOptions,
                    value: data.value,
                    type: event.type,
                    event
                });
                return;
            }
            comboboxState.selectOption(event, data);
        }),
        setHasFocus: comboboxState.setHasFocus,
        setOpen: comboboxState.setOpen,
        setValue: comboboxState.setValue,
        value: comboboxState.value
    };
};
const childrenToTriggerAndPopover = (children, noPopover)=>{
    const childrenArray = _react.Children.toArray(children);
    if (process.env.NODE_ENV !== 'production') {
        if (childrenArray.length === 0) {
            // eslint-disable-next-line no-console
            console.warn('TagPicker must contain at least one child');
        }
        if (childrenArray.length > 2) {
            // eslint-disable-next-line no-console
            console.warn('TagPicker must contain at most two children');
        }
    }
    if (noPopover) {
        return {
            trigger: childrenArray[0]
        };
    }
    let trigger = undefined;
    let popover = undefined;
    if (childrenArray.length === 2) {
        trigger = childrenArray[0];
        popover = childrenArray[1];
    } else if (childrenArray.length === 1) {
        popover = childrenArray[0];
    }
    return {
        trigger,
        popover
    };
};
