import type { ActiveDescendantContextValue } from '@fluentui/react-aria';
import { ComboboxBaseState } from '@fluentui/react-combobox';
import { ComboboxProps } from '@fluentui/react-combobox';
import { ComboboxSlots } from '@fluentui/react-combobox';
import type { ComboboxState } from '@fluentui/react-combobox';
import { ComponentProps } from '@fluentui/react-utilities';
import { ComponentState } from '@fluentui/react-utilities';
import { ContextSelector } from '@fluentui/react-context-selector';
import { DropdownProps } from '@fluentui/react-combobox';
import type { EventData } from '@fluentui/react-utilities';
import type { EventHandler } from '@fluentui/react-utilities';
import type { ExtractSlotProps } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import type { Listbox } from '@fluentui/react-combobox';
import type { ListboxContextValue } from '@fluentui/react-combobox';
import { OptionGroupProps } from '@fluentui/react-combobox';
import { OptionGroupSlots } from '@fluentui/react-combobox';
import { OptionGroupState } from '@fluentui/react-combobox';
import { OptionSlots } from '@fluentui/react-combobox';
import { OptionState } from '@fluentui/react-combobox';
import * as React_2 from 'react';
import { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';
import { TagGroupContextValues } from '@fluentui/react-tags';
import type { TagGroupSlots } from '@fluentui/react-tags';
import type { TagGroupState } from '@fluentui/react-tags';

/**
 * Render the final JSX of Picker
 */
export declare const renderTagPicker_unstable: (state: TagPickerState, contexts: TagPickerContextValues) => JSXElement;

/**
 * Render the final JSX of PickerButton
 */
export declare const renderTagPickerButton_unstable: (state: TagPickerButtonState) => JSXElement;

/**
 * Render the final JSX of PickerControl
 */
export declare const renderTagPickerControl_unstable: (state: TagPickerControlState) => JSXElement;

export declare function renderTagPickerGroup_unstable(state: TagPickerGroupState, contexts: TagGroupContextValues): JSXElement | null;

/**
 * Render the final JSX of TagPickerInput
 */
export declare const renderTagPickerInput_unstable: (state: TagPickerInputState) => JSXElement;

/**
 * Render the final JSX of TagPickerList
 */
export declare const renderTagPickerList_unstable: (state: TagPickerListState) => JSXElement;

/**
 * Render the final JSX of TagPickerOption
 */
export declare const renderTagPickerOption_unstable: (state: TagPickerOptionState) => JSXElement;

/**
 * Render the final JSX of TagPickerOptionGroup
 */
export declare const renderTagPickerOptionGroup: (state: TagPickerOptionGroupState) => JSXElement;

/**
 * TagPicker component -
 * A TagPicker is a composite component that allows users to pick tags from a list of options.
 */
export declare const TagPicker: React_2.FC<TagPickerProps>;

/**
 * TagPickerButton component -
 * A TagPickerButton is an alternative to TagPickerInput that does not include an input field.
 */
export declare const TagPickerButton: ForwardRefComponent<TagPickerButtonProps>;

export declare const tagPickerButtonClassNames: SlotClassNames<TagPickerButtonSlots>;

/**
 * PickerButton Props
 */
export declare type TagPickerButtonProps = ComponentProps<TagPickerButtonSlots> & Pick<DropdownProps, 'size' | 'appearance'> & {
    disabled?: boolean;
};

export declare type TagPickerButtonSlots = {
    root: Slot<'button'>;
};

/**
 * State used in rendering PickerButton
 */
export declare type TagPickerButtonState = ComponentState<TagPickerButtonSlots> & Pick<TagPickerContextValue, 'size'> & {
    hasSelectedOption: boolean;
};

export declare interface TagPickerContextValue extends Pick<ComboboxBaseState, 'open' | 'clearSelection' | 'getOptionById' | 'selectedOptions' | 'selectOption' | 'setHasFocus' | 'setOpen' | 'setValue' | 'value' | 'appearance' | 'disabled'> {
    triggerRef: React_2.RefObject<HTMLInputElement | HTMLButtonElement | null>;
    popoverRef: React_2.RefObject<HTMLDivElement | null>;
    popoverId: string;
    targetRef: React_2.RefObject<HTMLDivElement | null>;
    secondaryActionRef: React_2.RefObject<HTMLSpanElement | null>;
    tagPickerGroupRef: React_2.RefObject<HTMLDivElement | null>;
    size: TagPickerSize;
    noPopover?: boolean;
}

export declare type TagPickerContextValues = {
    picker: TagPickerContextValue;
    activeDescendant: ActiveDescendantContextValue;
    listbox: ListboxContextValue;
};

/**
 * TagPickerControl component -
 * A TagPickerControl is a composite component that controls actions and state for a TagPicker.
 */
export declare const TagPickerControl: ForwardRefComponent<TagPickerControlProps>;

export declare const tagPickerControlClassNames: SlotClassNames<TagPickerControlSlots & TagPickerControlInternalSlots>;

declare type TagPickerControlCSSProperties = React_2.CSSProperties & {
    '--fui-TagPickerControl-aside-width'?: string | number;
};

declare type TagPickerControlInternalSlots = {
    aside?: NonNullable<Slot<'span'>>;
};

/**
 * PickerControl Props
 */
export declare type TagPickerControlProps = ComponentProps<Partial<TagPickerControlSlots>>;

export declare type TagPickerControlSlots = {
    root: Slot<ExtractSlotProps<Slot<'div'> & {
        style?: TagPickerControlCSSProperties;
    }>>;
    /**
     * A secondary action should be a button-like element to be rendered right after
     * the trigger responsible for opening/closing the tag picker popover.
     */
    secondaryAction: Slot<'span'>;
} & Pick<ComboboxSlots, 'expandIcon'>;

/**
 * State used in rendering PickerControl
 */
export declare type TagPickerControlState = ComponentState<TagPickerControlSlots & TagPickerControlInternalSlots> & Pick<TagPickerContextValue, 'size' | 'appearance' | 'disabled'> & {
    invalid: boolean;
};

/**
 * TagPickerGroup component -
 * A TagPickerGroup is a composite component that allows users to group tags together.
 */
export declare const TagPickerGroup: ForwardRefComponent<TagPickerGroupProps>;

export declare const tagPickerGroupClassNames: SlotClassNames<TagPickerGroupSlots>;

/**
 * TagPickerGroup Props
 */
export declare type TagPickerGroupProps = ComponentProps<TagPickerGroupSlots>;

export declare type TagPickerGroupSlots = TagGroupSlots;

/**
 * State used in rendering TagPickerGroup
 */
export declare type TagPickerGroupState = TagGroupState & {
    hasSelectedOptions: boolean;
};

/**
 * TagPickerInput component -
 * A TagPickerInput is a composite component that allows users to query tags.
 */
export declare const TagPickerInput: ForwardRefComponent<TagPickerInputProps>;

export declare const tagPickerInputClassNames: SlotClassNames<TagPickerInputSlots>;

/**
 * TagPickerInput Props
 */
export declare type TagPickerInputProps = Omit<ComponentProps<Partial<TagPickerInputSlots>>, 'children' | 'size' | 'defaultValue'> & Pick<ComboboxProps, 'clearable' | 'appearance'> & {
    disabled?: boolean;
    value?: string;
};

export declare type TagPickerInputSlots = {
    root: NonNullable<Slot<'input'>>;
};

/**
 * State used in rendering TagPickerInput
 */
export declare type TagPickerInputState = ComponentState<TagPickerInputSlots> & Pick<TagPickerContextValue, 'size' | 'disabled'>;

/**
 * TagPickerList component -
 * A TagPickerList is a composite component that allows users to display a list of tag options to be selected.
 */
export declare const TagPickerList: ForwardRefComponent<TagPickerListProps>;

export declare const tagPickerListClassNames: SlotClassNames<TagPickerListSlots>;

/**
 * TagPickerList Props
 */
export declare type TagPickerListProps = ComponentProps<TagPickerListSlots>;

export declare type TagPickerListSlots = {
    root: Slot<typeof Listbox>;
};

/**
 * State used in rendering TagPickerList
 */
export declare type TagPickerListState = ComponentState<TagPickerListSlots> & Pick<TagPickerContextValue, 'open'>;

export declare type TagPickerOnOpenChangeData = {
    open: boolean;
} & (EventData<'click', React_2.MouseEvent<HTMLDivElement>> | EventData<'keydown', React_2.KeyboardEvent<HTMLDivElement>>);

/**
 * Event data for the `onOptionSelect` event.
 *
 * * value - The value of the selected option that triggered the event
 * * selectedOptions - The list of selected options
 */
export declare type TagPickerOnOptionSelectData = {
    value: string;
    selectedOptions: string[];
} & (EventData<'click', React_2.MouseEvent<HTMLDivElement>> | EventData<'keydown', React_2.KeyboardEvent<HTMLDivElement>>);

/**
 * TagPickerOption component -
 * A TagPickerOption is a composite component that allows users to select tags.
 */
export declare const TagPickerOption: ForwardRefComponent<TagPickerOptionProps>;

export declare const tagPickerOptionClassNames: SlotClassNames<TagPickerOptionSlots>;

/**
 * TagPickerOptionGroup component -
 * A TagPickerOptionGroup is a composite component that allows users to group TagPickerOptions.
 */
export declare const TagPickerOptionGroup: ForwardRefComponent<TagPickerOptionGroupProps>;

export declare const tagPickerOptionGroupClassNames: SlotClassNames<TagPickerOptionGroupSlots>;

/**
 * TagPickerOptionGroup Props
 */
export declare type TagPickerOptionGroupProps = OptionGroupProps;

export declare type TagPickerOptionGroupSlots = OptionGroupSlots;

/**
 * State used in rendering TagPickerOptionGroup
 */
export declare type TagPickerOptionGroupState = OptionGroupState;

/**
 * TagPickerOption Props
 */
export declare type TagPickerOptionProps = ComponentProps<TagPickerOptionSlots> & {
    value: string;
} & ({
    /**
     * An optional override the string value of the Option's display text,
     * defaulting to the Option's child content.
     * This is used as the Dropdown button's or Combobox input's value when the option is selected,
     * and as the comparison for type-to-find keyboard functionality.
     */
    text?: string;
    children: string;
} | {
    /**
     * The string value of the Option's display text when the Option's children are not a string.
     * This is used as the Dropdown button's or Combobox input's value when the option is selected,
     * and as the comparison for type-to-find keyboard functionality.
     */
    text: string;
    children?: React_2.ReactNode;
});

export declare type TagPickerOptionSlots = Pick<OptionSlots, 'root'> & {
    media?: Slot<'div'>;
    secondaryContent?: Slot<'span'>;
};

/**
 * State used in rendering TagPickerOption
 */
export declare type TagPickerOptionState = ComponentState<TagPickerOptionSlots> & Pick<OptionState, 'components' | 'root'>;

/**
 * Picker Props
 */
export declare type TagPickerProps = ComponentProps<TagPickerSlots> & Pick<ComboboxProps, 'positioning' | 'disabled' | 'defaultOpen' | 'selectedOptions' | 'defaultSelectedOptions' | 'open'> & Pick<Partial<TagPickerContextValue>, 'size' | 'appearance'> & {
    /**
     * By default, when a single children is provided, the TagPicker will assume that the children
     * is a popover. By setting this prop to true, the children will be treated as a trigger instead.
     *
     * @default false
     */
    noPopover?: boolean;
    onOpenChange?: EventHandler<TagPickerOnOpenChangeData>;
    onOptionSelect?: EventHandler<TagPickerOnOptionSelectData>;
    /**
     * Can contain two children including a trigger and a popover
     */
    children: [JSXElement, JSXElement | undefined | false] | JSXElement;
    /**
     * TagPickers are rendered out of DOM order on `document.body` by default,
     * use this to render the popover in DOM order
     *
     * @default false
     */
    inline?: boolean;
};

export declare type TagPickerSize = 'medium' | 'large' | 'extra-large';

export declare type TagPickerSlots = {};

/**
 * State used in rendering Picker
 */
export declare type TagPickerState = ComponentState<TagPickerSlots> & Pick<ComboboxState, 'open' | 'activeDescendantController' | 'mountNode' | 'onOptionClick' | 'registerOption' | 'selectedOptions' | 'selectOption' | 'value' | 'setValue' | 'setOpen' | 'setHasFocus' | 'appearance' | 'clearSelection' | 'getOptionById' | 'getOptionsMatchingValue' | 'disabled'> & Pick<TagPickerContextValue, 'triggerRef' | 'secondaryActionRef' | 'popoverId' | 'popoverRef' | 'targetRef' | 'tagPickerGroupRef' | 'size' | 'noPopover'> & {
    trigger: React_2.ReactNode;
    popover?: React_2.ReactNode;
    inline: boolean;
};

/**
 * Create the state required to render Picker.
 *
 * The returned state can be modified with hooks such as usePickerStyles_unstable,
 * before being passed to renderPicker_unstable.
 *
 * @param props - props from this instance of Picker
 */
export declare const useTagPicker_unstable: (props: TagPickerProps) => TagPickerState;

/**
 * Create the state required to render PickerButton.
 *
 * The returned state can be modified with hooks such as usePickerButtonStyles_unstable,
 * before being passed to renderPickerButton_unstable.
 *
 * @param props - props from this instance of PickerButton
 * @param ref - reference to root HTMLDivElement of PickerButton
 */
export declare const useTagPickerButton_unstable: (props: TagPickerButtonProps, ref: React_2.Ref<HTMLButtonElement>) => TagPickerButtonState;

/**
 * Apply styling to the PickerButton slots based on the state
 */
export declare const useTagPickerButtonStyles_unstable: (state: TagPickerButtonState) => TagPickerButtonState;

export declare const useTagPickerContext_unstable: <T>(selector: ContextSelector<TagPickerContextValue, T>) => T;

/**
 * Create the state required to render PickerControl.
 *
 * The returned state can be modified with hooks such as usePickerControlStyles_unstable,
 * before being passed to renderPickerControl_unstable.
 *
 * @param props - props from this instance of PickerControl
 * @param ref - reference to root HTMLDivElement of PickerControl
 */
export declare const useTagPickerControl_unstable: (props: TagPickerControlProps, ref: React_2.Ref<HTMLDivElement>) => TagPickerControlState;

/**
 * Apply styling to the PickerControl slots based on the state
 */
export declare const useTagPickerControlStyles_unstable: (state: TagPickerControlState) => TagPickerControlState;

export declare function useTagPickerFilter({ filter: filterOverride, noOptionsElement, renderOption, query, options, }: UseTagPickerFilterConfig): JSXElement[];

declare type UseTagPickerFilterConfig = {
    query: string;
    options: string[];
    /**
     * Provides a custom filter for the option.
     * By default the filter will check if the option includes the query.
     */
    filter?: (option: string, index: number) => boolean;
    /** Provides an element to be displayed when there are no options. */
    noOptionsElement: JSXElement;
    /** Provides a custom render for the option. */
    renderOption?: (option: string) => JSXElement;
};

/**
 * Create the state required to render TagPickerGroup.
 *
 * The returned state can be modified with hooks such as usePickerTagGroupStyles_unstable,
 * before being passed to renderPickerTagGroup_unstable.
 *
 * @param props - props from this instance of TagPickerGroup
 * @param ref - reference to root HTMLDivElement of TagPickerGroup
 */
export declare const useTagPickerGroup_unstable: (props: TagPickerGroupProps, ref: React_2.Ref<HTMLDivElement>) => TagPickerGroupState;

/**
 * Apply styling to the TagPickerGroup slots based on the state
 */
export declare const useTagPickerGroupStyles_unstable: (state: TagPickerGroupState) => TagPickerGroupState;

/**
 * Create the state required to render TagPickerInput.
 *
 * The returned state can be modified with hooks such as useTagPickerInputStyles_unstable,
 * before being passed to renderTagPickerInput_unstable.
 *
 * @param props - props from this instance of TagPickerInput
 * @param ref - reference to root HTMLDivElement of TagPickerInput
 */
export declare const useTagPickerInput_unstable: (propsArg: TagPickerInputProps, ref: React_2.Ref<HTMLInputElement>) => TagPickerInputState;

/**
 * Apply styling to the TagPickerInput slots based on the state
 */
export declare const useTagPickerInputStyles_unstable: (state: TagPickerInputState) => TagPickerInputState;

/**
 * Create the state required to render TagPickerList.
 *
 * The returned state can be modified with hooks such as useTagPickerListStyles_unstable,
 * before being passed to renderTagPickerList_unstable.
 *
 * @param props - props from this instance of TagPickerList
 * @param ref - reference to root HTMLDivElement of TagPickerList
 */
export declare const useTagPickerList_unstable: (props: TagPickerListProps, ref: React_2.Ref<HTMLDivElement>) => TagPickerListState;

/**
 * Apply styling to the TagPickerList slots based on the state
 */
export declare const useTagPickerListStyles_unstable: (state: TagPickerListState) => TagPickerListState;

/**
 * Create the state required to render TagPickerOption.
 *
 * The returned state can be modified with hooks such as useTagPickerOptionStyles_unstable,
 * before being passed to renderTagPickerOption_unstable.
 *
 * @param props - props from this instance of TagPickerOption
 * @param ref - reference to root HTMLDivElement of TagPickerOption
 */
export declare const useTagPickerOption_unstable: (props: TagPickerOptionProps, ref: React_2.Ref<HTMLDivElement>) => TagPickerOptionState;

/**
 * Create the state required to render TagPickerOptionGroup.
 *
 * The returned state can be modified with hooks such as useTagPickerOptionGroupStyles_unstable,
 * before being passed to renderTagPickerOptionGroup_unstable.
 *
 * @param props - props from this instance of TagPickerOptionGroup
 * @param ref - reference to root HTMLDivElement of TagPickerOptionGroup
 */
export declare const useTagPickerOptionGroup: (props: TagPickerOptionGroupProps, ref: React_2.Ref<HTMLDivElement>) => TagPickerOptionGroupState;

/**
 * Apply styling to the TagPickerOptionGroup slots based on the state
 */
export declare const useTagPickerOptionGroupStyles: (state: TagPickerOptionGroupState) => TagPickerOptionGroupState;

/**
 * Apply styling to the TagPickerOption slots based on the state
 */
export declare const useTagPickerOptionStyles_unstable: (state: TagPickerOptionState) => TagPickerOptionState;

export { }
