'use client';
import * as React from 'react';
import { createTabster, disposeTabster } from 'tabster';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
import { getParent, useIsomorphicLayoutEffect, usePrevious } from '@fluentui/react-utilities';
const DEFAULT_FACTORY = (tabster)=>{
    return tabster;
};
/**
 * Creates a tabster instance with the provided configuration
 *
 * @internal
 * @param targetDocument
 */ export function createTabsterWithConfig(targetDocument) {
    const defaultView = (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView) || undefined;
    const shadowDOMAPI = defaultView === null || defaultView === void 0 ? void 0 : defaultView.__tabsterShadowDOMAPI;
    if (defaultView) {
        return createTabster(defaultView, {
            autoRoot: {},
            controlTab: false,
            getParent,
            // The non-undefined return value of checkUncontrolledCompletely() dominates the value that the element might
            // have in its `uncontrolled: { completely: true }` part of the tabster attribute. We must make sure to return
            // undefined if we want the value from tabster attribute to be respected.
            checkUncontrolledCompletely: (element)=>{
                var _element_firstElementChild;
                return ((_element_firstElementChild = element.firstElementChild) === null || _element_firstElementChild === void 0 ? void 0 : _element_firstElementChild.hasAttribute('data-is-focus-trap-zone-bumper')) === true || undefined;
            },
            DOMAPI: shadowDOMAPI
        });
    }
}
export function useTabster(factory = DEFAULT_FACTORY) {
    const { targetDocument } = useFluent();
    const factoryResultRef = React.useRef(null);
    useIsomorphicLayoutEffect(()=>{
        const tabster = createTabsterWithConfig(targetDocument);
        if (tabster) {
            factoryResultRef.current = factory(tabster);
            return ()=>{
                disposeTabster(tabster);
                factoryResultRef.current = null;
            };
        }
    }, [
        targetDocument,
        factory
    ]);
    if (process.env.NODE_ENV !== 'production') {
        // eslint-disable-next-line
        const previousFactory = usePrevious(factory);
        if (previousFactory !== null && previousFactory !== factory) {
            throw new Error([
                '@fluentui/react-tabster: ',
                'The factory function passed to useTabster has changed. This should not ever happen.'
            ].join('\n'));
        }
    }
    return factoryResultRef;
}
