'use client';
import { getRestorer, getTabsterAttribute, RestorerTypes } from 'tabster';
import { useTabster } from './useTabster';
/**
 * Focus will be restored to the most recent target element when it is lost from a source
 * @returns Attribute to apply to the target element where focus is restored
 */ export function useRestoreFocusTarget() {
    // Initializes the restorer API
    useTabster(getRestorer);
    return getTabsterAttribute({
        restorer: {
            type: RestorerTypes.Target
        }
    });
}
/**
 * Focus will be restored to the most recent target element when it is lost from a source
 * @returns Attribute to apply to the element that might lose focus
 */ export function useRestoreFocusSource() {
    // Initializes the restorer API
    useTabster(getRestorer);
    return getTabsterAttribute({
        restorer: {
            type: RestorerTypes.Source
        }
    });
}
