'use client';
import { useId } from '@fluentui/react-utilities';
import { useTabsterAttributes } from './useTabsterAttributes';
import { getModalizer, getRestorer, RestorerTypes } from 'tabster';
import { useTabster } from './useTabster';
const DangerousNeverHiddenAttribute = 'data-tabster-never-hide';
const DangerousNeverHiddenPropObject = {
    [DangerousNeverHiddenAttribute]: ''
};
/**
 * !!DANGEROUS!! Designates an element that will not be hidden even when outside an open modal.
 * Only works for top-level elements; should be used with extreme care.
 * @returns Attribute to apply to the target element that should never receive aria-hidden
 */ export function useDangerousNeverHidden_unstable() {
    return DangerousNeverHiddenPropObject;
}
const tabsterAccessibleCheck = (element)=>{
    return element.hasAttribute(DangerousNeverHiddenAttribute);
};
function initTabsterModules(tabster) {
    getModalizer(tabster, undefined, tabsterAccessibleCheck);
    getRestorer(tabster);
}
/**
 * Applies modal dialog behaviour through DOM attributes
 * Modal element will focus trap and hide other content on the page
 * The trigger element will be focused if focus is lost after the modal element is removed
 *
 * @returns DOM attributes to apply to the modal element and its trigger
 */ export const useModalAttributes = (options = {})=>{
    const { trapFocus, alwaysFocusable, legacyTrapFocus } = options;
    // Initializes the modalizer and restorer APIs
    useTabster(initTabsterModules);
    const id = useId('modal-', options.id);
    const modalAttributes = useTabsterAttributes({
        restorer: {
            type: RestorerTypes.Source
        },
        ...trapFocus && {
            modalizer: {
                id,
                isOthersAccessible: !trapFocus,
                isAlwaysAccessible: alwaysFocusable,
                isTrapped: legacyTrapFocus && trapFocus
            }
        }
    });
    const triggerAttributes = useTabsterAttributes({
        restorer: {
            type: RestorerTypes.Target
        }
    });
    return {
        modalAttributes,
        triggerAttributes
    };
};
