'use client';
import * as React from 'react';
import { useKeyborgRef } from './useKeyborgRef';
/**
 * Instantiates [keyborg](https://github.com/microsoft/keyborg) and checks if the user is navigating with the keyboard.
 * @returns
 */ export function useIsNavigatingWithKeyboard() {
    const keyborgRef = useKeyborgRef();
    return React.useCallback(()=>{
        var _keyborgRef_current;
        var _keyborgRef_current_isNavigatingWithKeyboard;
        return (_keyborgRef_current_isNavigatingWithKeyboard = (_keyborgRef_current = keyborgRef.current) === null || _keyborgRef_current === void 0 ? void 0 : _keyborgRef_current.isNavigatingWithKeyboard()) !== null && _keyborgRef_current_isNavigatingWithKeyboard !== void 0 ? _keyborgRef_current_isNavigatingWithKeyboard : false;
    }, [
        keyborgRef
    ]);
}
