'use client';
import { getGroupper, GroupperTabbabilities } from 'tabster';
import { useTabsterAttributes } from './useTabsterAttributes';
import { useTabster } from './useTabster';
/**
 * A hook that returns the necessary tabster attributes to support groupping.
 * @param options - Options to configure keyboard navigation
 */ export const useFocusableGroup = (options)=>{
    useTabster(getGroupper);
    return useTabsterAttributes({
        groupper: {
            tabbability: getTabbability(options === null || options === void 0 ? void 0 : options.tabBehavior)
        },
        focusable: {
            ignoreKeydown: options === null || options === void 0 ? void 0 : options.ignoreDefaultKeydown
        }
    });
};
const getTabbability = (tabBehavior)=>{
    switch(tabBehavior){
        case 'unlimited':
            return GroupperTabbabilities.Unlimited;
        case 'limited':
            return GroupperTabbabilities.Limited;
        case 'limited-trap-focus':
            return GroupperTabbabilities.LimitedTrapFocus;
        default:
            return undefined;
    }
};
