'use client';
import * as React from 'react';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
import { useTabster } from './useTabster';
/**
 * Returns a set of helper functions that will traverse focusable elements in the context of a root DOM element
 */ export const useFocusFinders = ()=>{
    const tabsterRef = useTabster();
    const { targetDocument } = useFluent();
    // Narrow props for now and let need dictate additional props in the future
    const findAllFocusable = React.useCallback((container, acceptCondition)=>{
        var _tabsterRef_current;
        return container && ((_tabsterRef_current = tabsterRef.current) === null || _tabsterRef_current === void 0 ? void 0 : _tabsterRef_current.focusable.findAll({
            container,
            acceptCondition
        })) || [];
    }, [
        tabsterRef
    ]);
    const findFirstFocusable = React.useCallback((container)=>{
        var _tabsterRef_current;
        return container && ((_tabsterRef_current = tabsterRef.current) === null || _tabsterRef_current === void 0 ? void 0 : _tabsterRef_current.focusable.findFirst({
            container
        }));
    }, [
        tabsterRef
    ]);
    const findLastFocusable = React.useCallback((container)=>{
        var _tabsterRef_current;
        return container && ((_tabsterRef_current = tabsterRef.current) === null || _tabsterRef_current === void 0 ? void 0 : _tabsterRef_current.focusable.findLast({
            container
        }));
    }, [
        tabsterRef
    ]);
    const findNextFocusable = React.useCallback((currentElement, options = {})=>{
        if (!tabsterRef.current || !targetDocument || !currentElement) {
            return null;
        }
        const { container = targetDocument.body } = options;
        return tabsterRef.current.focusable.findNext({
            currentElement,
            container
        });
    }, [
        tabsterRef,
        targetDocument
    ]);
    const findPrevFocusable = React.useCallback((currentElement, options = {})=>{
        if (!tabsterRef.current || !targetDocument || !currentElement) {
            return null;
        }
        const { container = targetDocument.body } = options;
        return tabsterRef.current.focusable.findPrev({
            currentElement,
            container
        });
    }, [
        tabsterRef,
        targetDocument
    ]);
    return {
        findAllFocusable,
        findFirstFocusable,
        findLastFocusable,
        findNextFocusable,
        findPrevFocusable
    };
};
