'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTabsterAttributes", {
    enumerable: true,
    get: function() {
        return useTabsterAttributes;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _tabster = require("tabster");
const _useTabster = require("./useTabster");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const useTabsterAttributes = (props)=>{
    // A tabster instance is not necessary to generate tabster attributes
    // but calling the hook will ensure that a tabster instance exists internally and avoids consumers doing the same
    (0, _useTabster.useTabster)();
    const strAttr = (0, _tabster.getTabsterAttribute)(props, true);
    return _react.useMemo(()=>({
            [_tabster.TABSTER_ATTRIBUTE_NAME]: strAttr
        }), [
        strAttr
    ]);
};
