'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createTabsterWithConfig: function() {
        return createTabsterWithConfig;
    },
    useTabster: function() {
        return useTabster;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _tabster = require("tabster");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reactutilities = require("@fluentui/react-utilities");
const DEFAULT_FACTORY = (tabster)=>{
    return tabster;
};
function createTabsterWithConfig(targetDocument) {
    const defaultView = (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView) || undefined;
    const shadowDOMAPI = defaultView === null || defaultView === void 0 ? void 0 : defaultView.__tabsterShadowDOMAPI;
    if (defaultView) {
        return (0, _tabster.createTabster)(defaultView, {
            autoRoot: {},
            controlTab: false,
            getParent: _reactutilities.getParent,
            // The non-undefined return value of checkUncontrolledCompletely() dominates the value that the element might
            // have in its `uncontrolled: { completely: true }` part of the tabster attribute. We must make sure to return
            // undefined if we want the value from tabster attribute to be respected.
            checkUncontrolledCompletely: (element)=>{
                var _element_firstElementChild;
                return ((_element_firstElementChild = element.firstElementChild) === null || _element_firstElementChild === void 0 ? void 0 : _element_firstElementChild.hasAttribute('data-is-focus-trap-zone-bumper')) === true || undefined;
            },
            DOMAPI: shadowDOMAPI
        });
    }
}
function useTabster(factory = DEFAULT_FACTORY) {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const factoryResultRef = _react.useRef(null);
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        const tabster = createTabsterWithConfig(targetDocument);
        if (tabster) {
            factoryResultRef.current = factory(tabster);
            return ()=>{
                (0, _tabster.disposeTabster)(tabster);
                factoryResultRef.current = null;
            };
        }
    }, [
        targetDocument,
        factory
    ]);
    if (process.env.NODE_ENV !== 'production') {
        // eslint-disable-next-line
        const previousFactory = (0, _reactutilities.usePrevious)(factory);
        if (previousFactory !== null && previousFactory !== factory) {
            throw new Error([
                '@fluentui/react-tabster: ',
                'The factory function passed to useTabster has changed. This should not ever happen.'
            ].join('\n'));
        }
    }
    return factoryResultRef;
}
