'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useOnKeyboardNavigationChange", {
    enumerable: true,
    get: function() {
        return useOnKeyboardNavigationChange;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _useKeyborgRef = require("./useKeyborgRef");
function useOnKeyboardNavigationChange(callback) {
    const keyborgRef = (0, _useKeyborgRef.useKeyborgRef)();
    const eventCallback = (0, _reactutilities.useEventCallback)(callback);
    _react.useEffect(()=>{
        const keyborg = keyborgRef.current;
        if (keyborg) {
            const cb = (next)=>{
                eventCallback(next);
            };
            keyborg.subscribe(cb);
            cb(keyborg.isNavigatingWithKeyboard());
            return ()=>{
                keyborg.unsubscribe(cb);
            };
        }
    }, [
        keyborgRef,
        eventCallback
    ]);
}
