'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useKeyborgRef", {
    enumerable: true,
    get: function() {
        return useKeyborgRef;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _keyborg = require("keyborg");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
function useKeyborgRef() {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const keyborgRef = _react.useRef(null);
    _react.useEffect(()=>{
        const targetWindow = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView;
        if (targetWindow) {
            const keyborg = (0, _keyborg.createKeyborg)(targetWindow);
            keyborgRef.current = keyborg;
            return ()=>{
                (0, _keyborg.disposeKeyborg)(keyborg);
                keyborgRef.current = null;
            };
        }
    }, [
        targetDocument
    ]);
    return keyborgRef;
}
