'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useKeyboardNavAttribute", {
    enumerable: true,
    get: function() {
        return useKeyboardNavAttribute;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _keyborg = require("keyborg");
const _constants = require("../focus/constants");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
function useKeyboardNavAttribute() {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const keyborg = _react.useMemo(()=>targetDocument && (0, _keyborg.createKeyborg)(targetDocument.defaultView), [
        targetDocument
    ]);
    const ref = _react.useRef(null);
    _react.useEffect(()=>{
        if (keyborg) {
            setBooleanAttribute(ref, _constants.KEYBOARD_NAV_ATTRIBUTE, keyborg.isNavigatingWithKeyboard());
            const cb = (next)=>{
                setBooleanAttribute(ref, _constants.KEYBOARD_NAV_ATTRIBUTE, next);
            };
            keyborg.subscribe(cb);
            return ()=>keyborg.unsubscribe(cb);
        }
    }, [
        keyborg
    ]);
    return ref;
}
function setBooleanAttribute(elementRef, attribute, value) {
    if (!elementRef.current) {
        return;
    }
    if (value) {
        elementRef.current.setAttribute(attribute, '');
    } else {
        elementRef.current.removeAttribute(attribute);
    }
}
