'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useFocusedElementChange", {
    enumerable: true,
    get: function() {
        return useFocusedElementChange;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _tabster = require("tabster");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reactutilities = require("@fluentui/react-utilities");
const _useTabster = require("./useTabster");
function useFocusedElementChange(callback) {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const listener = (0, _reactutilities.useEventCallback)(callback);
    _react.useEffect(()=>{
        const tabster = (0, _useTabster.createTabsterWithConfig)(targetDocument);
        if (tabster) {
            tabster.focusedElement.subscribe(listener);
            return ()=>{
                tabster.focusedElement.unsubscribe(listener);
                (0, _tabster.disposeTabster)(tabster);
            };
        }
    }, [
        listener,
        targetDocument
    ]);
}
