'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useFocusableGroup", {
    enumerable: true,
    get: function() {
        return useFocusableGroup;
    }
});
const _tabster = require("tabster");
const _useTabsterAttributes = require("./useTabsterAttributes");
const _useTabster = require("./useTabster");
const useFocusableGroup = (options)=>{
    (0, _useTabster.useTabster)(_tabster.getGroupper);
    return (0, _useTabsterAttributes.useTabsterAttributes)({
        groupper: {
            tabbability: getTabbability(options === null || options === void 0 ? void 0 : options.tabBehavior)
        },
        focusable: {
            ignoreKeydown: options === null || options === void 0 ? void 0 : options.ignoreDefaultKeydown
        }
    });
};
const getTabbability = (tabBehavior)=>{
    switch(tabBehavior){
        case 'unlimited':
            return _tabster.GroupperTabbabilities.Unlimited;
        case 'limited':
            return _tabster.GroupperTabbabilities.Limited;
        case 'limited-trap-focus':
            return _tabster.GroupperTabbabilities.LimitedTrapFocus;
        default:
            return undefined;
    }
};
