'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useFocusWithin", {
    enumerable: true,
    get: function() {
        return useFocusWithin;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _focusWithinPolyfill = require("../focus/focusWithinPolyfill");
function useFocusWithin() {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const elementRef = _react.useRef(null);
    _react.useEffect(()=>{
        if ((targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.defaultView) && elementRef.current) {
            return (0, _focusWithinPolyfill.applyFocusWithinPolyfill)(elementRef.current, targetDocument.defaultView);
        }
    }, [
        elementRef,
        targetDocument
    ]);
    return elementRef;
}
