'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useFocusObserved", {
    enumerable: true,
    get: function() {
        return useFocusObserved;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _tabster = require("tabster");
const _useTabster = require("./useTabster");
function useFocusObserved(name, options = {}) {
    const { timeout = 1000 } = options;
    const observedAPIRef = (0, _useTabster.useTabster)(_tabster.getObservedElement);
    return _react.useCallback(()=>{
        const observerAPI = observedAPIRef.current;
        if (observerAPI) {
            return observerAPI.requestFocus(name, timeout);
        }
        return {
            result: Promise.resolve(false),
            cancel: ()=>null
        };
    }, [
        observedAPIRef,
        name,
        timeout
    ]);
}
