'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useFocusFinders", {
    enumerable: true,
    get: function() {
        return useFocusFinders;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _useTabster = require("./useTabster");
const useFocusFinders = ()=>{
    const tabsterRef = (0, _useTabster.useTabster)();
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    // Narrow props for now and let need dictate additional props in the future
    const findAllFocusable = _react.useCallback((container, acceptCondition)=>{
        var _tabsterRef_current;
        return container && ((_tabsterRef_current = tabsterRef.current) === null || _tabsterRef_current === void 0 ? void 0 : _tabsterRef_current.focusable.findAll({
            container,
            acceptCondition
        })) || [];
    }, [
        tabsterRef
    ]);
    const findFirstFocusable = _react.useCallback((container)=>{
        var _tabsterRef_current;
        return container && ((_tabsterRef_current = tabsterRef.current) === null || _tabsterRef_current === void 0 ? void 0 : _tabsterRef_current.focusable.findFirst({
            container
        }));
    }, [
        tabsterRef
    ]);
    const findLastFocusable = _react.useCallback((container)=>{
        var _tabsterRef_current;
        return container && ((_tabsterRef_current = tabsterRef.current) === null || _tabsterRef_current === void 0 ? void 0 : _tabsterRef_current.focusable.findLast({
            container
        }));
    }, [
        tabsterRef
    ]);
    const findNextFocusable = _react.useCallback((currentElement, options = {})=>{
        if (!tabsterRef.current || !targetDocument || !currentElement) {
            return null;
        }
        const { container = targetDocument.body } = options;
        return tabsterRef.current.focusable.findNext({
            currentElement,
            container
        });
    }, [
        tabsterRef,
        targetDocument
    ]);
    const findPrevFocusable = _react.useCallback((currentElement, options = {})=>{
        if (!tabsterRef.current || !targetDocument || !currentElement) {
            return null;
        }
        const { container = targetDocument.body } = options;
        return tabsterRef.current.focusable.findPrev({
            currentElement,
            container
        });
    }, [
        tabsterRef,
        targetDocument
    ]);
    return {
        findAllFocusable,
        findFirstFocusable,
        findLastFocusable,
        findNextFocusable,
        findPrevFocusable
    };
};
