'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useArrowNavigationGroup", {
    enumerable: true,
    get: function() {
        return useArrowNavigationGroup;
    }
});
const _tabster = require("tabster");
const _useTabsterAttributes = require("./useTabsterAttributes");
const _useTabster = require("./useTabster");
const useArrowNavigationGroup = (options = {})=>{
    const { circular, axis, memorizeCurrent = true, tabbable, ignoreDefaultKeydown, // eslint-disable-next-line @typescript-eslint/naming-convention
    unstable_hasDefault } = options;
    (0, _useTabster.useTabster)(_tabster.getMover);
    return (0, _useTabsterAttributes.useTabsterAttributes)({
        mover: {
            cyclic: !!circular,
            direction: axisToMoverDirection(axis !== null && axis !== void 0 ? axis : 'vertical'),
            memorizeCurrent,
            tabbable,
            hasDefault: unstable_hasDefault
        },
        ...ignoreDefaultKeydown && {
            focusable: {
                ignoreKeydown: ignoreDefaultKeydown
            }
        }
    });
};
function axisToMoverDirection(axis) {
    switch(axis){
        case 'horizontal':
            return _tabster.MoverDirections.Horizontal;
        case 'grid':
            return _tabster.MoverDirections.Grid;
        case 'grid-linear':
            return _tabster.MoverDirections.GridLinear;
        case 'both':
            return _tabster.MoverDirections.Both;
        case 'vertical':
        default:
            return _tabster.MoverDirections.Vertical;
    }
}
