'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useActivateModal", {
    enumerable: true,
    get: function() {
        return useActivateModal;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _tabster = require("tabster");
const _reactutilities = require("@fluentui/react-utilities");
const _useTabster = require("./useTabster");
function useActivateModal() {
    const modalizerRefAPI = (0, _useTabster.useTabster)(_tabster.getModalizer);
    const [setActivateModalTimeout] = (0, _reactutilities.useTimeout)();
    const activateModal = _react.useCallback((elementFromModal)=>{
        // We call the actual activation function on the next tick, because with the typical use case,
        // the hook will be called on the same tick when other Tabster attributes are being applied,
        // and on the current tick the element has just received the attributes, but Tabster has not
        // instantiated the Modalizer yet.
        setActivateModalTimeout(()=>{
            var _modalizerRefAPI_current;
            (_modalizerRefAPI_current = modalizerRefAPI.current) === null || _modalizerRefAPI_current === void 0 ? void 0 : _modalizerRefAPI_current.activate(elementFromModal);
        }, 0);
    }, [
        modalizerRefAPI,
        setActivateModalTimeout
    ]);
    return activateModal;
}
