"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createFocusOutlineStyle", {
    enumerable: true,
    get: function() {
        return createFocusOutlineStyle;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const _createCustomFocusIndicatorStyle = require("./createCustomFocusIndicatorStyle");
const _constants = require("./constants");
/**
 * Get the position of the focus outline
 *
 * @param options - Configures the style of the focus outline
 * @param position - The position of the focus outline
 * @returns CSS value for the position of the focus outline
 */ function getOutlinePosition({ outlineWidth, outlineOffset }, position) {
    const offsetValue = (outlineOffset === null || outlineOffset === void 0 ? void 0 : outlineOffset[position]) || outlineOffset;
    if (!outlineOffset) {
        return `calc(${outlineWidth} * -1)`;
    }
    return `calc(0px - ${outlineWidth} - ${offsetValue})`;
}
/**
 * NOTE: the element with the focus outline needs to have `position: relative` so that the
 * pseudo element can be properly positioned.
 *
 * @param options - Configures the style of the focus outline
 * @returns focus outline styles object
 */ const getFocusOutlineStyles = (options)=>{
    const { outlineRadius, outlineColor, outlineWidth } = options;
    return {
        ..._react.shorthands.borderColor('transparent'),
        '@media (forced-colors: active)': {
            '::after': {
                ..._react.shorthands.borderColor('Highlight')
            }
        },
        '::after': {
            content: '""',
            position: 'absolute',
            pointerEvents: 'none',
            zIndex: 1,
            border: `${outlineWidth} solid ${outlineColor}`,
            borderRadius: outlineRadius,
            top: getOutlinePosition(options, 'top'),
            right: getOutlinePosition(options, 'right'),
            bottom: getOutlinePosition(options, 'bottom'),
            left: getOutlinePosition(options, 'left')
        }
    };
};
const createFocusOutlineStyle = ({ enableOutline = false, selector = _constants.defaultOptions.selector, customizeSelector, style = _constants.defaultOptions.style } = _constants.defaultOptions)=>({
        ':focus': {
            outlineStyle: enableOutline ? undefined : 'none'
        },
        ':focus-visible': {
            outlineStyle: enableOutline ? undefined : 'none'
        },
        ...(0, _createCustomFocusIndicatorStyle.createCustomFocusIndicatorStyle)(getFocusOutlineStyles({
            outlineColor: _reacttheme.tokens.colorStrokeFocus2,
            outlineRadius: _reacttheme.tokens.borderRadiusMedium,
            // FIXME: tokens.strokeWidthThick causes some weird bugs
            outlineWidth: '2px',
            ...style
        }), {
            selector,
            customizeSelector
        })
    });
