import { dispatchGroupperMoveFocusEvent } from 'tabster';
import { dispatchMoverMoveFocusEvent } from 'tabster';
import { EventsTypes } from 'tabster';
import type { GriffelStyle } from '@griffel/react';
import { GroupperMoveFocusActions } from 'tabster';
import { GroupperMoveFocusEvent } from 'tabster';
import { GroupperMoveFocusEventName } from 'tabster';
import { KEYBORG_FOCUSIN } from 'keyborg';
import { KeyborgFocusInEvent } from 'keyborg';
import { makeResetStyles } from '@griffel/react';
import { MoverKeys } from 'tabster';
import { MoverMemorizedElementEvent } from 'tabster';
import { MoverMemorizedElementEventName } from 'tabster';
import { MoverMoveFocusEvent } from 'tabster';
import { MoverMoveFocusEventName } from 'tabster';
import * as React_2 from 'react';
import { TabsterMoveFocusEvent } from 'tabster';
import { TabsterMoveFocusEventName } from 'tabster';
import { Types } from 'tabster';

/**
 * @internal
 * @param scope - Applies the ponyfill to all DOM children
 * @param targetWindow - window
 */
export declare function applyFocusVisiblePolyfill(scope: HTMLElement, targetWindow: Window): () => void;

/**
 * Creates a style for @see makeStyles that includes the necessary selectors for focus.
 * Should be used only when @see createFocusOutlineStyle does not fit requirements
 *
 * If you're using `createCustomFocusIndicatorStyle` instead of `createFocusOutlineStyle`
 * keep in mind that the default outline style is not going to be removed
 * (as it is in `createFocusOutlineStyle`),
 * and is your responsibility to manually remove it from your styles.
 *
 * @example
 * ```ts
 * // Link styles
 * const useStyles = makeStyles({
 focusIndicator: createCustomFocusIndicatorStyle({
 textDecorationColor: tokens.colorStrokeFocus2,
 textDecorationLine: 'underline',
 textDecorationStyle: 'double',
 outlineStyle: 'none',
 }),
 // Common styles.
 root: {
 // ❗️ DO NOT FORGET TO REMOVE THE DEFAULT OUTLINE STYLE
 ':focus-visible': {
 outlineStyle: 'none',
 },
 * ```
 *
 * @param style - styling applied on focus, defaults to @see getDefaultFocusOutlineStyles
 * @param options - Configure the style of the focus outline
 */
export declare function createCustomFocusIndicatorStyle<TStyle extends GriffelStyle | GriffelResetStyle>(style: TStyle, { selector: selectorType, customizeSelector, }?: CreateCustomFocusIndicatorStyleOptions): TStyle extends GriffelStyle ? GriffelStyle : GriffelResetStyle;

export declare interface CreateCustomFocusIndicatorStyleOptions {
    /**
     * Control if the indicator appears when the corresponding element is focused,
     * or any child is focused within the corresponding element.
     * @default 'focus'
     * @alias selectorType
     */
    selector?: 'focus' | 'focus-within';
    /**
     * Customizes the selector provided based on the selector type.
     */
    customizeSelector?: (selector: string) => string;
    /**
     * Enables the browser default outline style
     * @deprecated The custom focus indicator no longer affects outline styles. Outline is overridden
     * in the default focus indicator function, `createFocusOutlineStyle`.
     */
    enableOutline?: boolean;
}

/**
 * NOTE: The element with the focus outline needs to have `position: relative` so that the
 * pseudo element can be properly positioned.
 *
 * @param options - Configure the style of the focus outline
 * @returns focus outline styles object for @see makeStyles
 */
export declare const createFocusOutlineStyle: ({ enableOutline, selector, customizeSelector, style, }?: CreateFocusOutlineStyleOptions) => GriffelStyle;

export declare interface CreateFocusOutlineStyleOptions extends Omit<CreateCustomFocusIndicatorStyleOptions, 'enableOutline'> {
    style?: Partial<FocusOutlineStyleOptions>;
    /**
     * Enables the browser default outline style
     */
    enableOutline?: boolean;
}

declare interface CrossOriginAPI {
    focusedElement: CrossOriginFocusedElementState;
    observedElement: CrossOriginObservedElementState;
    setup(sendUp?: CrossOriginTransactionSend | null): (msg: CrossOriginMessage) => void;
    isSetUp(): boolean;
    dispose(): void;
}

declare interface CrossOriginElement {
    readonly uid: string;
    readonly ownerId: string;
    readonly id?: string;
    readonly rootId?: string;
    readonly observedName?: string;
    readonly observedDetails?: string;
    focus(noFocusedProgrammaticallyFlag?: boolean, noAccessibleCheck?: boolean): Promise<boolean>;
}

declare interface CrossOriginFocusedElementState extends Subscribable<CrossOriginElement | undefined, FocusedElementDetails>, Disposable {
    focus(element: CrossOriginElement, noFocusedProgrammaticallyFlag?: boolean, noAccessibleCheck?: boolean): Promise<boolean>;
    focusById(elementId: string, rootId?: string, noFocusedProgrammaticallyFlag?: boolean, noAccessibleCheck?: boolean): Promise<boolean>;
    focusByObservedName(observedName: string, timeout?: number, rootId?: string, noFocusedProgrammaticallyFlag?: boolean, noAccessibleCheck?: boolean): Promise<boolean>;
}

declare interface CrossOriginMessage {
    data: CrossOriginTransactionData<any, any>;
    send: CrossOriginTransactionSend;
}

declare interface CrossOriginObservedElementState extends Subscribable<CrossOriginElement, ObservedElementProps>, Disposable {
    getElement(observedName: string, accessibility?: ObservedElementAccesibility): Promise<CrossOriginElement | null>;
    waitElement(observedName: string, timeout: number, accessibility?: ObservedElementAccesibility): Promise<CrossOriginElement | null>;
    requestFocus(observedName: string, timeout: number): Promise<boolean>;
}

declare interface CrossOriginSentTo {
    [id: string]: true;
}

declare interface CrossOriginTransactionData<I, O> {
    transaction: string;
    type: CrossOriginTransactionType;
    isResponse: boolean;
    timestamp: number;
    owner: string;
    sentto: CrossOriginSentTo;
    timeout?: number;
    target?: string;
    beginData?: I;
    endData?: O;
}

declare type CrossOriginTransactionSend = (data: CrossOriginTransactionData<any, any>) => void;

declare type CrossOriginTransactionType = CrossOriginTransactionTypes[keyof CrossOriginTransactionTypes];

declare interface CrossOriginTransactionTypes {
    Bootstrap: 1;
    FocusElement: 2;
    State: 3;
    GetElement: 4;
    RestoreFocusInDeloser: 5;
    Ping: 6;
}

declare interface Deloser extends TabsterPart<DeloserProps> {
    readonly uid: string;
    dispose(): void;
    isActive(): boolean;
    setActive(active: boolean): void;
    getActions(): DeloserElementActions;
    setSnapshot(index: number): void;
    focusFirst(): boolean;
    unshift(element: HTMLElement): void;
    focusDefault(): boolean;
    resetFocus(): boolean;
    findAvailable(): HTMLElement | null;
    clearHistory(preserveExisting?: boolean): void;
    customFocusLostHandler(element: HTMLElement): boolean;
}

declare interface DeloserAPI extends DeloserInterfaceInternal, Disposable {
    getActions(element: HTMLElement): DeloserElementActions | undefined;
    pause(): void;
    resume(restore?: boolean): void;
}

declare type DeloserConstructor = (element: HTMLElement, props: DeloserProps) => Deloser;

declare interface DeloserElementActions {
    focusDefault: () => boolean;
    focusFirst: () => boolean;
    resetFocus: () => boolean;
    clearHistory: (preserveExisting?: boolean) => void;
    setSnapshot: (index: number) => void;
    isActive: () => boolean;
}

declare const DeloserEventName = "tabster:deloser";

declare interface DeloserInterfaceInternal {
    /** @internal */
    createDeloser(element: HTMLElement, props: DeloserProps): Deloser;
}

declare interface DeloserOnElement {
    deloser: Deloser;
}

declare interface DeloserProps {
    restoreFocusOrder?: RestoreFocusOrder;
    noSelectorCheck?: boolean;
}

export { dispatchGroupperMoveFocusEvent }

export { dispatchMoverMoveFocusEvent }

declare interface Disposable {
    /** @internal */
    dispose(): void;
}

declare type DisposeFunc = () => void;

declare interface DOMAPI {
    createMutationObserver: (callback: MutationCallback) => MutationObserver;
    createTreeWalker(doc: Document, root: Node, whatToShow?: number, filter?: NodeFilter | null): TreeWalker;
    getParentNode(node: Node | null | undefined): ParentNode | null;
    getParentElement(element: HTMLElement | null | undefined): HTMLElement | null;
    nodeContains(parent: Node | null | undefined, child: Node | null | undefined): boolean;
    getActiveElement(doc: Document): Element | null;
    querySelector(element: ParentNode, selector: string): Element | null;
    querySelectorAll(element: ParentNode, selector: string): Element[];
    getElementById(doc: Document, id: string): HTMLElement | null;
    getFirstChild(node: Node | null | undefined): ChildNode | null;
    getLastChild(node: Node | null | undefined): ChildNode | null;
    getNextSibling(node: Node | null | undefined): ChildNode | null;
    getPreviousSibling(node: Node | null | undefined): ChildNode | null;
    getFirstElementChild(element: Element | null | undefined): Element | null;
    getLastElementChild(element: Element | null | undefined): Element | null;
    getNextElementSibling(element: Element | null | undefined): Element | null;
    getPreviousElementSibling(element: Element | null | undefined): Element | null;
    appendChild(parent: Node, child: Node): Node;
    insertBefore(parent: Node, child: Node, referenceChild: Node | null): Node;
    getSelection(ref: Node): Selection | null;
}

declare interface DummyInputManager {
    moveOut: (backwards: boolean) => void;
    moveOutWithDefaultAction: (backwards: boolean, relatedEvent: KeyboardEvent) => void;
}

declare interface DummyInputObserver {
    add(dummy: HTMLElement, callback: () => void): void;
    remove(dummy: HTMLElement): void;
    dispose(): void;
    domChanged?(parent: HTMLElement): void;
    updatePositions(compute: (scrollTopLeftCache: Map<HTMLElement, {
        scrollTop: number;
        scrollLeft: number;
    } | null>) => () => void): void;
}

declare type FindAllProps = Pick<FindFocusableProps, 'container' | 'modalizerId' | 'currentElement' | 'isBackward' | 'includeProgrammaticallyFocusable' | 'useActiveModalizer' | 'acceptCondition' | 'ignoreAccessibility' | 'onElement'>;

declare type FindDefaultProps = Pick<FindFocusableProps, 'container' | 'modalizerId' | 'includeProgrammaticallyFocusable' | 'useActiveModalizer' | 'ignoreAccessibility'>;

/**
 * A callback that is called for every found element during search. Returning false stops search.
 */
declare type FindElementCallback = (element: HTMLElement) => boolean;

declare type FindFirstProps = Pick<FindFocusableProps, 'container' | 'modalizerId' | 'includeProgrammaticallyFocusable' | 'useActiveModalizer' | 'ignoreAccessibility'>;

declare interface FindFocusableOutputProps {
    /**
     * An output parameter. Will be true after the findNext/findPrev() call if some focusable
     * elements were skipped during the search and the result element not immediately next
     * focusable after the currentElement.
     */
    outOfDOMOrder?: boolean;
    /**
     * An output parameter. Will be true if the found element is uncontrolled.
     */
    uncontrolled?: HTMLElement | null;
}

declare interface FindFocusableProps {
    /**
     * The container used for the search.
     */
    container: HTMLElement;
    /**
     * The elemet to start from.
     */
    currentElement?: HTMLElement;
    /**
     * See `referenceElement` of GetTabsterContextOptions for description.
     */
    referenceElement?: HTMLElement;
    /**
     * Includes elements that can be focused programmatically.
     */
    includeProgrammaticallyFocusable?: boolean;
    /**
     * Ignore accessibility check.
     */
    ignoreAccessibility?: boolean;
    /**
     * Take active modalizer into account when searching for elements
     * (the elements out of active modalizer will not be returned).
     */
    useActiveModalizer?: boolean;
    /**
     * Search withing the specified modality, null for everything outside of modalizers, string within
     * a specific id, undefined for search within the current application state.
     */
    modalizerId?: string | null;
    /**
     * If true, find previous element instead of the next one.
     */
    isBackward?: boolean;
    /**
     * @param el - element visited.
     * @returns if an element should be accepted.
     */
    acceptCondition?(el: HTMLElement): boolean;
    /**
     * A callback that will be called for every focusable element found during findAll().
     * If false is returned from this callback, the search will stop.
     */
    onElement?: FindElementCallback;
}

declare type FindNextProps = Pick<FindFocusableProps, 'currentElement' | 'referenceElement' | 'container' | 'modalizerId' | 'includeProgrammaticallyFocusable' | 'useActiveModalizer' | 'ignoreAccessibility'>;

declare interface FocusableAcceptElementState {
    container: HTMLElement;
    modalizerUserId?: string;
    currentCtx?: TabsterContext;
    from: HTMLElement;
    fromCtx?: TabsterContext;
    isBackward?: boolean;
    found?: boolean;
    foundElement?: HTMLElement;
    foundBackward?: HTMLElement;
    rejectElementsFrom?: HTMLElement;
    uncontrolled?: HTMLElement;
    acceptCondition: (el: HTMLElement) => boolean;
    hasCustomCondition?: boolean;
    includeProgrammaticallyFocusable?: boolean;
    ignoreAccessibility?: boolean;
    cachedGrouppers: {
        [id: string]: {
            isActive: boolean | undefined;
            first?: HTMLElement | null;
        };
    };
    isFindAll?: boolean;
    /**
     * A flag that indicates that some focusable elements were skipped
     * during the search and the found element is not the one the browser
     * would normally focus if the user pressed Tab.
     */
    skippedFocusable?: boolean;
}

declare interface FocusableAPI extends Disposable {
    getProps(element: HTMLElement): FocusableProps;
    isFocusable(element: HTMLElement, includeProgrammaticallyFocusable?: boolean, noVisibleCheck?: boolean, noAccessibleCheck?: boolean): boolean;
    isVisible(element: HTMLElement): boolean;
    isAccessible(element: HTMLElement): boolean;
    findFirst(options: FindFirstProps, out?: FindFocusableOutputProps): HTMLElement | null | undefined;
    findLast(options: FindFirstProps, out?: FindFocusableOutputProps): HTMLElement | null | undefined;
    findNext(options: FindNextProps, out?: FindFocusableOutputProps): HTMLElement | null | undefined;
    findPrev(options: FindNextProps, out?: FindFocusableOutputProps): HTMLElement | null | undefined;
    findDefault(options: FindDefaultProps, out?: FindFocusableOutputProps): HTMLElement | null;
    /**
     * @returns All focusables in a given context that satisfy an given condition
     */
    findAll(options: FindAllProps): HTMLElement[];
    findElement(options: FindFocusableProps, out?: FindFocusableOutputProps): HTMLElement | null | undefined;
}

declare interface FocusableOnElement {
    focusable: FocusableProps;
}

declare interface FocusableProps {
    isDefault?: boolean;
    isIgnored?: boolean;
    /**
     * Do not determine an element's focusability based on aria-disabled.
     */
    ignoreAriaDisabled?: boolean;
    /**
     * Exclude element (and all subelements) from Mover navigation.
     */
    excludeFromMover?: boolean;
    /**
     * Prevents tabster from handling the keydown event
     */
    ignoreKeydown?: {
        Tab?: boolean;
        Escape?: boolean;
        Enter?: boolean;
        ArrowUp?: boolean;
        ArrowDown?: boolean;
        ArrowLeft?: boolean;
        ArrowRight?: boolean;
        PageUp?: boolean;
        PageDown?: boolean;
        Home?: boolean;
        End?: boolean;
    };
}

declare const FocusableSelector: string;

declare interface FocusedElementDetails {
    relatedTarget?: HTMLElement;
    isFocusedProgrammatically?: boolean;
    modalizerId?: string;
}

declare interface FocusedElementState extends Subscribable<HTMLElement | undefined, FocusedElementDetails>, Disposable {
    getFocusedElement(): HTMLElement | undefined;
    getLastFocusedElement(): HTMLElement | undefined;
    focus(element: HTMLElement, noFocusedProgrammaticallyFlag?: boolean, noAccessibleCheck?: boolean): boolean;
    focusDefault(container: HTMLElement): boolean;
    /** @internal */
    getFirstOrLastTabbable(isFirst: boolean, props: Pick<FindFocusableProps, 'container' | 'ignoreAccessibility'>): HTMLElement | undefined;
    focusFirst(props: FindFirstProps): boolean;
    focusLast(props: FindFirstProps): boolean;
    resetFocus(container: HTMLElement): boolean;
}

declare const FocusInEventName = "tabster:focusin";

declare const FocusOutEventName = "tabster:focusout";

export declare type FocusOutlineOffset = Record<'top' | 'bottom' | 'left' | 'right', string>;

export declare type FocusOutlineStyleOptions = {
    /**
     * Only property not supported by the native CSS `outline`, if this is no longer needed
     * we can just go native instead
     */
    outlineRadius: string;
    outlineColor: string;
    outlineWidth: string;
    outlineOffset?: string | FocusOutlineOffset;
};

declare type GetTabster = () => TabsterCore;

declare interface GetTabsterContextOptions {
    /**
     * Should visit **all** element ancestors to verify if `dir='rtl'` is set
     */
    checkRtl?: boolean;
    /**
     * The element to start computing the context from. Useful when dealing
     * with nested structures. For example, if we have an element inside a groupper
     * inside another groupper, the `groupper` prop in this element's contexts will
     * be the inner groupper, but when we pass the inner groupper's parent element
     * as `referenceElement`, the context groupper will be the outer one. Having
     * this option simplifies searching for the next tabbable element in the
     * environment of nested movers and grouppers.
     */
    referenceElement?: HTMLElement;
}

declare type GetWindow = () => Window;

declare type GriffelResetStyle = Parameters<typeof makeResetStyles>[0];

declare interface Groupper extends TabsterPart<GroupperProps>, TabsterPartWithFindNextTabbable, TabsterPartWithAcceptElement {
    readonly id: string;
    readonly dummyManager: DummyInputManager | undefined;
    dispose(): void;
    makeTabbable(isUnlimited: boolean): void;
    isActive(noIfFirstIsFocused?: boolean): boolean | undefined;
    setFirst(element: HTMLElement | undefined): void;
    getFirst(orContainer: boolean): HTMLElement | undefined;
}

declare interface GroupperAPI extends GroupperAPIInternal, Disposable {
    /** @internal (will likely be exposed once the API is fully stable) */
    moveFocus(element: HTMLElement, action: GroupperMoveFocusAction): HTMLElement | null;
}

declare interface GroupperAPIInternal {
    /** @internal */
    createGroupper(element: HTMLElement, props: GroupperProps, sys: SysProps | undefined): Groupper;
    /** @internal */
    handleKeyPress(element: HTMLElement, event: KeyboardEvent, fromModalizer?: boolean): void;
}

declare interface GroupperAPIInternal {
    forgetCurrentGrouppers(): void;
}

declare type GroupperConstructor = (tabster: TabsterCore, element: HTMLElement, props: GroupperProps) => Groupper;

declare type GroupperMoveFocusAction = GroupperMoveFocusActions_2[keyof GroupperMoveFocusActions_2];

export { GroupperMoveFocusActions }

declare interface GroupperMoveFocusActions_2 {
    Enter: 1;
    Escape: 2;
}

declare const GroupperMoveFocusActions_2: GroupperMoveFocusActions_2;

export { GroupperMoveFocusEvent }

declare type GroupperMoveFocusEvent_2 = CustomEvent<{
    action: GroupperMoveFocusAction;
} | undefined>;

export declare type GroupperMoveFocusEventDetail = EventsTypes.GroupperMoveFocusEventDetail;

export { GroupperMoveFocusEventName }

declare const GroupperMoveFocusEventName_2 = "tabster:groupper:movefocus";

declare interface GroupperOnElement {
    groupper: Groupper;
}

declare interface GroupperProps {
    tabbability?: GroupperTabbability;
    delegated?: boolean;
}

declare interface GroupperTabbabilities {
    Unlimited: 0;
    Limited: 1;
    LimitedTrapFocus: 2;
}

declare const GroupperTabbabilities: GroupperTabbabilities;

declare type GroupperTabbability = GroupperTabbabilities[keyof GroupperTabbabilities];

declare interface InternalAPI {
    stopObserver(): void;
    resumeObserver(syncState: boolean): void;
}

declare interface KeyboardNavigationState extends Subscribable<boolean>, Disposable {
    isNavigatingWithKeyboard(): boolean;
    setNavigatingWithKeyboard(isNavigatingWithKeyboard: boolean): void;
}

export { KEYBORG_FOCUSIN }

export { KeyborgFocusInEvent }

declare interface Modalizer extends TabsterPart<ModalizerProps>, TabsterPartWithFindNextTabbable {
    readonly userId: string;
    readonly dummyManager: DummyInputManager | undefined;
    /**
     * @returns - Whether the element is inside the modalizer
     */
    contains(element: HTMLElement): boolean;
    dispose(): void;
    isActive(): boolean;
    makeActive(isActive: boolean): void;
    focused(noIncrement?: boolean): number;
    triggerFocusEvent(eventName: ModalizerEventName, allElements: boolean): boolean;
}

declare const ModalizerActiveEventName = "tabster:modalizer:active";

declare interface ModalizerAPI extends ModalizerAPIInternal, Disposable {
    /**
     * Activates a Modalizer and focuses the first or default element within
     *
     * @param elementFromModalizer - An element that belongs to a Modalizer
     * @param noFocusFirst - Do not focus on the first element in the Modalizer
     * @param noFocusDefault - Do not focus the default element in the Modalizre
     */
    focus(elementFromModalizer: HTMLElement, noFocusFirst?: boolean, noFocusDefault?: boolean): boolean;
}

declare interface ModalizerAPIInternal extends TabsterPartWithAcceptElement {
    /** @internal */
    activeId: string | undefined;
    /** @internal */
    currentIsOthersAccessible: boolean | undefined;
    /** @internal */
    activeElements: WeakHTMLElement<HTMLElement>[];
    /** @internal */
    createModalizer(element: HTMLElement, props: ModalizerProps, sys: SysProps | undefined): Modalizer;
    /**
     * Sets active modalizers.
     * When active, everything outside of the modalizers with the specific user
     * defined id gets `aria-hidden`.
     *
     * @param userId - user defined identifier or undefined (if nothing is modal).
     */
    /** @internal */
    setActive(modalizer: Modalizer | undefined): void;
    /** @internal */
    hiddenUpdate(): void;
    /** @internal */
    isAugmented(element: HTMLElement): boolean;
}

declare const ModalizerBeforeFocusOutEventName = "tabster:modalizer:beforefocusout";

declare type ModalizerConstructor = (tabster: TabsterCore, element: HTMLElement, props: ModalizerProps) => Modalizer;

/**
 * A signature for the accessibleCheck callback from getModalizer().
 * It is called when active Modalizer sets aria-hidden on elements outsidef of it.
 *
 * @param element - The element that is about to receive aria-hidden.
 * @param activeModalizerElements - The container elements of the active modalizer.
 * @returns true if the element should remain accessible and should not receive
 * aria-hidden.
 */
declare type ModalizerElementAccessibleCheck = (element: HTMLElement, activeModalizerElements?: HTMLElement[]) => boolean;

declare type ModalizerEvent = TabsterEventWithDetails<ModalizerEventDetails>;

declare type ModalizerEventDetails = {
    id: string;
    element: HTMLElement;
    eventName: ModalizerEventName;
};

declare type ModalizerEventName = typeof ModalizerActiveEventName | typeof ModalizerInactiveEventName | typeof ModalizerBeforeFocusOutEventName | typeof ModalizerFocusInEventName | typeof ModalizerFocusOutEventName;

declare const ModalizerFocusInEventName = "tabster:modalizer:focusin";

declare const ModalizerFocusOutEventName = "tabster:modalizer:focusout";

declare const ModalizerInactiveEventName = "tabster:modalizer:inactive";

declare interface ModalizerOnElement {
    modalizer: Modalizer;
}

declare interface ModalizerProps {
    id: string;
    isOthersAccessible?: boolean;
    isAlwaysAccessible?: boolean;
    isNoFocusFirst?: boolean;
    isNoFocusDefault?: boolean;
    /** A focus trap variant, keeps focus inside the modal when tabbing */
    isTrapped?: boolean;
}

declare const MoveFocusEventName = "tabster:movefocus";

declare interface Mover extends TabsterPart<MoverProps>, TabsterPartWithFindNextTabbable, TabsterPartWithAcceptElement {
    readonly id: string;
    readonly dummyManager: DummyInputManager | undefined;
    readonly visibilityTolerance: NonNullable<MoverProps['visibilityTolerance']>;
    dispose(): void;
    setCurrent(element: HTMLElement | undefined): void;
    getCurrent(): HTMLElement | null;
    getState(element: HTMLElement): MoverElementState | undefined;
}

declare interface MoverAPI extends MoverAPIInternal, Disposable {
    /** @internal (will likely be exposed once the API is fully stable) */
    moveFocus(fromElement: HTMLElement, key: MoverKey): HTMLElement | null;
}

declare interface MoverAPIInternal {
    /** @internal */
    createMover(element: HTMLElement, props: MoverProps, sys: SysProps | undefined): Mover;
}

declare type MoverConstructor = (tabster: TabsterCore, element: HTMLElement, props: MoverProps) => Mover;

declare type MoverDirection = MoverDirections[keyof MoverDirections];

declare interface MoverDirections {
    Both: 0;
    Vertical: 1;
    Horizontal: 2;
    Grid: 3;
    GridLinear: 4;
}

declare const MoverDirections: MoverDirections;

declare interface MoverElementState {
    isCurrent: boolean | undefined;
    visibility: Visibility;
}

declare type MoverEvent = TabsterEventWithDetails<MoverElementState>;

declare const MoverEventName = "tabster:mover";

declare type MoverKey = MoverKeys_2[keyof MoverKeys_2];

export { MoverKeys }

declare interface MoverKeys_2 {
    ArrowUp: 1;
    ArrowDown: 2;
    ArrowLeft: 3;
    ArrowRight: 4;
    PageUp: 5;
    PageDown: 6;
    Home: 7;
    End: 8;
}

declare const MoverKeys_2: MoverKeys_2;

export { MoverMemorizedElementEvent }

export declare type MoverMemorizedElementEventDetail = EventsTypes.MoverMemorizedElementEventDetail;

export { MoverMemorizedElementEventName }

export { MoverMoveFocusEvent }

declare type MoverMoveFocusEvent_2 = CustomEvent<{
    key: MoverKey;
} | undefined>;

export declare type MoverMoveFocusEventDetail = EventsTypes.MoverMoveFocusEventDetail;

export { MoverMoveFocusEventName }

declare const MoverMoveFocusEventName_2 = "tabster:mover:movefocus";

declare interface MoverOnElement {
    mover: Mover;
}

declare interface MoverProps {
    direction?: MoverDirection;
    memorizeCurrent?: boolean;
    tabbable?: boolean;
    /**
     * Whether to allow cyclic navigation in the mover
     * Can only be applied if navigationType is MoverKeys.Arrows
     *
     * @defaultValue false
     */
    cyclic?: boolean;
    /**
     * In case we need a rich state of the elements inside a Mover,
     * we can track it. It takes extra resourses and might affect
     * performance when a Mover has many elements inside, so make sure
     * you use this prop when it is really needed.
     */
    trackState?: boolean;
    /**
     * When set to Visibility.Visible or Visibility.PartiallyVisible,
     * uses the visibility part of the trackState prop to be able to
     * go to first/last visible element (instead of first/last focusable
     * element in DOM) when tabbing from outside of the mover.
     */
    visibilityAware?: Visibility;
    /**
     * When true, Mover will try to locate a focusable with Focusable.isDefault
     * property as a prioritized element to focus. True by default.
     */
    hasDefault?: boolean;
    /**
     * A value between 0 and 1 that specifies the tolerance allowed
     * when testing for visibility.
     *
     * @example
     * an element of height 100px has 10px that are above the viewport
     * hidden by scroll. This element is a valid visible element to focus.
     *
     * @default 0.8
     */
    visibilityTolerance?: number;
}

declare type NextTabbable = {
    element: HTMLElement | null | undefined;
    uncontrolled?: HTMLElement | null;
    outOfDOMOrder?: boolean;
};

declare interface ObservedElementAccesibilities {
    Any: 0;
    Accessible: 1;
    Focusable: 2;
}

declare const ObservedElementAccesibilities: ObservedElementAccesibilities;

declare type ObservedElementAccesibility = ObservedElementAccesibilities[keyof ObservedElementAccesibilities];

declare interface ObservedElementAPI extends Subscribable<HTMLElement, ObservedElementDetails>, Disposable, ObservedElementAPIInternal {
    getElement(observedName: string, accessibility?: ObservedElementAccesibility): HTMLElement | null;
    waitElement(observedName: string, timeout: number, accessibility?: ObservedElementAccesibility): ObservedElementAsyncRequest<HTMLElement | null>;
    requestFocus(observedName: string, timeout: number): ObservedElementAsyncRequest<boolean>;
}

declare interface ObservedElementAPIInternal {
    /** @internal */
    onObservedElementUpdate(element: HTMLElement): void;
}

declare interface ObservedElementAsyncRequest<T> {
    result: Promise<T>;
    cancel(): void;
}

declare interface ObservedElementDetails extends ObservedElementProps {
    accessibility?: ObservedElementAccesibility;
}

declare interface ObservedElementProps {
    names: string[];
    details?: any;
}

declare interface ObservedOnElement {
    observed: ObservedElementProps;
}

declare interface OutlineAPI extends Disposable {
    setup(props?: Partial<OutlineProps>): void;
}

declare interface OutlinedElementProps {
    isIgnored?: boolean;
}

declare interface OutlineElements {
    container: HTMLDivElement;
    left: HTMLDivElement;
    top: HTMLDivElement;
    right: HTMLDivElement;
    bottom: HTMLDivElement;
}

declare interface OutlineOnElement {
    outline: OutlinedElementProps;
}

declare interface OutlineProps {
    areaClass: string;
    outlineClass: string;
    outlineColor: string;
    outlineWidth: number;
    zIndex: number;
}

declare type RestoreFocusOrder = RestoreFocusOrders[keyof RestoreFocusOrders];

declare interface RestoreFocusOrders {
    History: 0;
    DeloserDefault: 1;
    RootDefault: 2;
    DeloserFirst: 3;
    RootFirst: 4;
}

declare const RestoreFocusOrders: RestoreFocusOrders;

declare interface Restorer extends Disposable, TabsterPart<RestorerProps> {
}

declare interface RestorerAPI extends RestorerAPIInternal, Disposable {
}

declare interface RestorerAPIInternal {
    /** @internal */
    createRestorer(element: HTMLElement, props: RestorerProps): Restorer;
}

declare interface RestorerOnElement {
    restorer: Restorer;
}

declare interface RestorerProps {
    type: RestorerType;
}

declare type RestorerType = (typeof RestorerTypes)[keyof typeof RestorerTypes];

declare const RestorerTypes: {
    readonly Source: 0;
    readonly Target: 1;
};

declare interface Root extends TabsterPart<RootProps> {
    /**@internal*/
    addDummyInputs(): void;
    readonly uid: string;
    dispose(): void;
    moveOutWithDefaultAction(backwards: boolean, relatedEvent: KeyboardEvent): void;
}

declare interface RootAPI extends Disposable, RootAPIInternal {
    eventTarget: EventTarget;
}

declare interface RootAPIInternal {
    /**@internal*/
    createRoot(element: HTMLElement, props: RootProps, sys: SysProps | undefined): Root;
    /**@internal*/
    onRoot(root: Root, removed?: boolean): void;
    /**@internal*/
    addDummyInputs(): void;
}

declare type RootConstructor = (tabster: TabsterCore, element: HTMLElement, props: RootProps) => Root;

declare interface RootFocusEventDetails {
    element: HTMLElement;
}

declare interface RootOnElement {
    root: Root;
}

declare interface RootProps {
    restoreFocusOrder?: RestoreFocusOrder;
}

declare interface Subscribable<A, B = undefined> {
    subscribe(callback: SubscribableCallback<A, B>): void;
    /** @internal */
    subscribeFirst(callback: SubscribableCallback<A, B>): void;
    unsubscribe(callback: SubscribableCallback<A, B>): void;
}

declare type SubscribableCallback<A, B = undefined> = (val: A, details: B) => void;

declare type SysDummyInputsPosition = SysDummyInputsPositions[keyof SysDummyInputsPositions];

declare interface SysDummyInputsPositions {
    Auto: 0;
    Inside: 1;
    Outside: 2;
}

declare const SysDummyInputsPositions: SysDummyInputsPositions;

declare interface SysOnElement {
    sys: SysProps;
}

/**
 * Ability to fine-tune Tabster internal behaviour in rare cases of need.
 * Normally, should not be used. A deep understanding of the intention and the effect
 * is required.
 */
declare interface SysProps {
    /**
     * Force dummy input position outside or inside of the element.
     * By default (when undefined), the position is determined dynamically
     * (for example inside for <li> elements and outside for <table> elements,
     * plus a default Groupper/Mover/Modalizer implementation position).
     * Setting to true will force the dummy inputs to be always outside of the element,
     * setting to false will force the dummy inputs to be always inside.
     */
    dummyInputsPosition?: SysDummyInputsPosition;
}

declare interface Tabster {
    keyboardNavigation: KeyboardNavigationState;
    focusedElement: FocusedElementState;
    focusable: FocusableAPI;
    root: RootAPI;
    uncontrolled: UncontrolledAPI;
    /** @internal */
    core: TabsterCore;
}

/**
 * WARNING! ATTENTION! WARNING! ATTENTION! WARNING! ATTENTION!
 * WARNING! ATTENTION! WARNING! ATTENTION! WARNING! ATTENTION!
 *
 * Do not use anything from this file. It is a snapshot of the older Tabster typings exposed by a mistake.
 * The exposed typings should have been removed, but we don't do it in minor versions to avoid breaking changes.
 * Everything reexported from this file as react-tabster/TabsterTypes is marked as deprecated and shouldn't
 * be used anywhre.
 *
 * WARNING! ATTENTION! WARNING! ATTENTION! WARNING! ATTENTION!
 * WARNING! ATTENTION! WARNING! ATTENTION! WARNING! ATTENTION!
 */
declare const TabsterAttributeName = "data-tabster";

declare interface TabsterAttributeOnElement {
    string: string;
    object: TabsterAttributeProps;
}

declare type TabsterAttributeProps = Partial<{
    deloser: DeloserProps;
    root: RootProps;
    uncontrolled: UncontrolledProps;
    modalizer: ModalizerProps;
    focusable: FocusableProps;
    groupper: GroupperProps;
    mover: MoverProps;
    observed: ObservedElementProps;
    outline: OutlinedElementProps;
    sys: SysProps;
    restorer: RestorerProps;
}>;

declare interface TabsterAugmentedAttributes {
    [name: string]: string | null;
}

declare interface TabsterCompat {
    attributeTransform?: <P>(old: P) => TabsterAttributeProps;
}

declare interface TabsterContext {
    root: Root;
    modalizer?: Modalizer;
    groupper?: Groupper;
    mover?: Mover;
    groupperBeforeMover?: boolean;
    modalizerInGroupper?: Groupper;
    /**
     * Whether `dir='rtl'` is set on an ancestor
     */
    rtl?: boolean;
    excludedFromMover?: boolean;
    uncontrolled?: HTMLElement | null;
    ignoreKeydown: (e: KeyboardEvent) => boolean;
}

declare type TabsterContextMoverGroupper = {
    isMover: true;
    mover: Mover;
} | {
    isMover: false;
    groupper: Groupper;
};

declare interface TabsterCore extends Pick<TabsterCoreProps, 'controlTab' | 'rootDummyInputs'>, Disposable, TabsterCoreInternal, Omit<Tabster, 'core'> {
}

declare interface TabsterCoreInternal {
    /** @internal */
    groupper?: GroupperAPI;
    /** @internal */
    mover?: MoverAPI;
    /** @internal */
    outline?: OutlineAPI;
    /** @internal */
    deloser?: DeloserAPI;
    /** @internal */
    modalizer?: ModalizerAPI;
    /** @internal */
    observedElement?: ObservedElementAPI;
    /** @internal */
    crossOrigin?: CrossOriginAPI;
    /** @internal */
    internal: InternalAPI;
    /** @internal */
    restorer?: RestorerAPI;
    /** @internal */
    _dummyObserver: DummyInputObserver;
    /** @internal */
    _version: string;
    /** @internal */
    _noop: boolean;
    /** @internal */
    storageEntry(element: HTMLElement, addremove?: boolean): TabsterElementStorageEntry | undefined;
    /** @internal */
    getWindow: GetWindow;
    /** @internal */
    createTabster(noRefCount?: boolean, props?: TabsterCoreProps): Tabster;
    /** @internal */
    disposeTabster(wrapper: Tabster, allInstances?: boolean): void;
    /** @internal */
    forceCleanup(): void;
    /** @internal */
    queueInit(callback: () => void): void;
    /** @internal */
    drainInitQueue(): void;
    /** @internal */
    getParent: (el: Node) => Node | null;
}

declare interface TabsterCoreProps {
    autoRoot?: RootProps;
    /**
     * Allows all tab key presses under the tabster root to be controlled by tabster
     * @default true
     */
    controlTab?: boolean;
    /**
     * When controlTab is false, Root doesn't have dummy inputs by default.
     * This option allows to enable dummy inputs on Root.
     */
    rootDummyInputs?: boolean;
    /**
     * A callback that will be called for the uncontrolled areas when Tabster wants
     * to know is the uncontrolled element wants complete control (for example it
     * is trapping focus) and Tabster should not interfere with handling Tab.
     * If the callback returns undefined, then the default behaviour is to return
     * the uncontrolled.completely value from the element. If the callback returns
     * non-undefined value, the callback's value will dominate the element's
     * uncontrolled.completely value.
     */
    checkUncontrolledCompletely?: (element: HTMLElement, completely: boolean) => boolean | undefined;
    /**
     * @deprecated use checkUncontrolledCompletely.
     */
    checkUncontrolledTrappingFocus?: (element: HTMLElement) => boolean;
    /**
     * Custom getter for parent elements. Defaults to the default .parentElement call
     * Currently only used to detect tabster contexts
     */
    getParent?(el: Node): Node | null;
    /**
     * Ability to redefine all DOM API calls used by Tabster. For example, for
     * ShadowDOM support.
     */
    DOMAPI?: Partial<DOMAPI>;
}

export declare type TabsterDOMAttribute = Types.TabsterDOMAttribute;

declare interface TabsterDOMAttribute_2 {
    [TabsterAttributeName]: string | undefined;
}

declare const TabsterDummyInputAttributeName = "data-tabster-dummy";

declare interface TabsterElementStorage {
    [uid: string]: TabsterElementStorageEntry;
}

declare interface TabsterElementStorageEntry {
    tabster?: TabsterOnElement;
    attr?: TabsterAttributeOnElement;
    aug?: TabsterAugmentedAttributes;
}

declare type TabsterEventWithDetails<D> = CustomEvent<D | undefined>;

export { TabsterMoveFocusEvent }

declare type TabsterMoveFocusEvent_2 = TabsterEventWithDetails<TabsterMoveFocusEventDetails>;

export declare type TabsterMoveFocusEventDetail = EventsTypes.TabsterMoveFocusEventDetail;

declare interface TabsterMoveFocusEventDetails {
    by: 'mover' | 'groupper' | 'modalizer' | 'root';
    owner: HTMLElement;
    next: HTMLElement | null;
    relatedEvent?: KeyboardEvent;
}

export { TabsterMoveFocusEventName }

declare type TabsterOnElement = Partial<RootOnElement & DeloserOnElement & ModalizerOnElement & FocusableOnElement & MoverOnElement & GroupperOnElement & ObservedOnElement & OutlineOnElement & UncontrolledOnElement & SysOnElement & RestorerOnElement>;

declare interface TabsterPart<P> {
    readonly id: string;
    getElement(): HTMLElement | undefined;
    getProps(): P;
    setProps(props: P): void;
}

declare interface TabsterPartWithAcceptElement {
    acceptElement(element: HTMLElement, state: FocusableAcceptElementState): number | undefined;
}

declare interface TabsterPartWithFindNextTabbable {
    findNextTabbable(current?: HTMLElement, reference?: HTMLElement, isBackward?: boolean, ignoreAccessibility?: boolean): NextTabbable | null;
}

declare namespace TabsterTypes {
    export {
        TabsterAttributeName,
        TabsterDummyInputAttributeName,
        DeloserEventName,
        ModalizerActiveEventName,
        ModalizerInactiveEventName,
        ModalizerFocusInEventName,
        ModalizerFocusOutEventName,
        ModalizerBeforeFocusOutEventName,
        MoverEventName,
        FocusInEventName,
        FocusOutEventName,
        MoveFocusEventName,
        MoverMoveFocusEventName_2 as MoverMoveFocusEventName,
        GroupperMoveFocusEventName_2 as GroupperMoveFocusEventName,
        FocusableSelector,
        MoverMoveFocusEvent_2 as MoverMoveFocusEvent,
        GroupperMoveFocusActions_2 as GroupperMoveFocusActions,
        GroupperMoveFocusAction,
        GroupperMoveFocusEvent_2 as GroupperMoveFocusEvent,
        TabsterEventWithDetails,
        TabsterMoveFocusEventDetails,
        TabsterMoveFocusEvent_2 as TabsterMoveFocusEvent,
        TabsterDOMAttribute_2 as TabsterDOMAttribute,
        TabsterCoreProps,
        DOMAPI,
        GetTabster,
        GetWindow,
        SubscribableCallback,
        Disposable,
        Subscribable,
        KeyboardNavigationState,
        FocusedElementDetails,
        FocusedElementState,
        WeakHTMLElement,
        TabsterPart,
        TabsterPartWithFindNextTabbable,
        TabsterPartWithAcceptElement,
        ObservedElementProps,
        ObservedElementDetails,
        ObservedElementAccesibilities,
        ObservedElementAccesibility,
        ObservedElementAsyncRequest,
        ObservedElementAPI,
        CrossOriginElement,
        CrossOriginSentTo,
        CrossOriginTransactionTypes,
        CrossOriginTransactionType,
        CrossOriginTransactionData,
        CrossOriginTransactionSend,
        CrossOriginMessage,
        CrossOriginFocusedElementState,
        CrossOriginObservedElementState,
        CrossOriginAPI,
        OutlineProps,
        OutlinedElementProps,
        OutlineAPI,
        DeloserElementActions,
        RestoreFocusOrders,
        RestoreFocusOrder,
        DeloserProps,
        Deloser,
        DeloserConstructor,
        DeloserAPI,
        FocusableProps,
        FocusableAcceptElementState,
        FindFocusableProps,
        FindFocusableOutputProps,
        FindFirstProps,
        FindNextProps,
        FindDefaultProps,
        FindAllProps,
        FindElementCallback,
        FocusableAPI,
        DummyInputManager,
        Visibilities,
        Visibility,
        MoverElementState,
        MoverDirections,
        RestorerTypes,
        RestorerType,
        MoverDirection,
        NextTabbable,
        MoverProps,
        MoverEvent,
        Mover,
        MoverConstructor,
        MoverKeys_2 as MoverKeys,
        MoverKey,
        MoverAPI,
        GroupperTabbabilities,
        GroupperTabbability,
        GroupperProps,
        Groupper,
        GroupperConstructor,
        GroupperAPIInternal,
        GroupperAPI,
        ModalizerProps,
        ModalizerEventName,
        ModalizerEventDetails,
        ModalizerEvent,
        Modalizer,
        ModalizerConstructor,
        RootProps,
        Root,
        RootConstructor,
        SysDummyInputsPositions,
        SysDummyInputsPosition,
        SysProps,
        GetTabsterContextOptions,
        TabsterContextMoverGroupper,
        TabsterContext,
        RootFocusEventDetails,
        RootAPI,
        UncontrolledAPI,
        ModalizerAPI,
        RestorerAPI,
        Restorer,
        ModalizerElementAccessibleCheck,
        UncontrolledProps,
        DeloserOnElement,
        RootOnElement,
        ModalizerOnElement,
        RestorerOnElement,
        FocusableOnElement,
        MoverOnElement,
        GroupperOnElement,
        UncontrolledOnElement,
        ObservedOnElement,
        OutlineOnElement,
        SysOnElement,
        RestorerProps,
        TabsterAttributeProps,
        TabsterAttributeOnElement,
        TabsterAugmentedAttributes,
        TabsterOnElement,
        OutlineElements,
        TabsterElementStorageEntry,
        TabsterElementStorage,
        DisposeFunc,
        InternalAPI,
        DummyInputObserver,
        Tabster,
        TabsterCore,
        TabsterCompat
    }
}
export { TabsterTypes }

declare interface UncontrolledAPI {
    isUncontrolledCompletely(element: HTMLElement, completely: boolean): boolean;
}

declare interface UncontrolledOnElement {
    uncontrolled: UncontrolledProps;
}

declare interface UncontrolledProps {
    completely?: boolean;
}

/**
 * Returns a function that activates a modal by element from the modal or modal container.
 */
export declare function useActivateModal(): (elementFromModal: HTMLElement | undefined) => void;

/**
 * A hook that returns the necessary tabster attributes to support arrow key navigation
 * @param options - Options to configure keyboard navigation
 */
export declare const useArrowNavigationGroup: (options?: UseArrowNavigationGroupOptions) => Types.TabsterDOMAttribute;

export declare interface UseArrowNavigationGroupOptions {
    /**
     * Focus will navigate vertically, horizontally or in both directions (grid), defaults to horizontally
     * @defaultValue vertical
     */
    axis?: 'vertical' | 'horizontal' | 'grid' | 'grid-linear' | 'both';
    /**
     * Focus will cycle to the first/last elements of the group without stopping
     */
    circular?: boolean;
    /**
     * Last focused element in the group will be remembered and focused (if still
     * available) when tabbing from outside of the group
     * @default true
     */
    memorizeCurrent?: boolean;
    /**
     * Allow tabbing within the arrow navigation group items.
     */
    tabbable?: boolean;
    /**
     * Tabster should ignore default handling of keydown events
     */
    ignoreDefaultKeydown?: Types.FocusableProps['ignoreKeydown'];
    /**
     * The default focusable item in the group will be an element with Focusable.isDefault property.
     * Note that there is no way in \@fluentui/react-tabster to set default focusable element,
     * and this option is currently for internal testing purposes only.
     */
    unstable_hasDefault?: boolean;
}

/**
 * !!DANGEROUS!! Designates an element that will not be hidden even when outside an open modal.
 * Only works for top-level elements; should be used with extreme care.
 * @returns Attribute to apply to the target element that should never receive aria-hidden
 */
export declare function useDangerousNeverHidden_unstable(): {
    [key: string]: string;
};

/**
 * A hook that returns the necessary tabster attributes to support groupping.
 * @param options - Options to configure keyboard navigation
 */
export declare const useFocusableGroup: (options?: UseFocusableGroupOptions) => Types.TabsterDOMAttribute;

export declare interface UseFocusableGroupOptions {
    /**
     * Behavior for the Tab key.
     */
    tabBehavior?: 'unlimited' | 'limited' | 'limited-trap-focus';
    /**
     * Tabster can ignore default handling of keydown events
     */
    ignoreDefaultKeydown?: Types.FocusableProps['ignoreKeydown'];
}

/**
 * Subscribes to the tabster focused element. Calls the callback when the focused element changes.
 * @param callback - Callback to subscribe to the focused element.
 */
export declare function useFocusedElementChange(callback: Types.SubscribableCallback<HTMLElement | undefined, Types.FocusedElementDetail>): void;

/**
 * Returns a set of helper functions that will traverse focusable elements in the context of a root DOM element
 */
export declare const useFocusFinders: () => {
    findAllFocusable: (container: HTMLElement | null, acceptCondition?: (el: HTMLElement) => boolean) => HTMLElement[];
    findFirstFocusable: (container: HTMLElement | null) => HTMLElement | null | undefined;
    findLastFocusable: (container: HTMLElement | null) => HTMLElement | null | undefined;
    findNextFocusable: (currentElement: HTMLElement | null, options?: {
        container?: HTMLElement;
    }) => HTMLElement | null | undefined;
    findPrevFocusable: (currentElement: HTMLElement | null, options?: {
        container?: HTMLElement;
    }) => HTMLElement | null | undefined;
};

/**
 * @param name - The observed element to focus
 * @param options - Options for the focus observed
 *
 * @returns Function that will focus an element
 */
export declare function useFocusObserved(name: string, options?: UseFocusObservedOptions): () => Types.ObservedElementAsyncRequest<boolean>;

declare interface UseFocusObservedOptions {
    /**
     * After timeout the focus attempt fails
     */
    timeout?: number;
}

export declare function useFocusVisible<TElement extends HTMLElement = HTMLElement>(options?: UseFocusVisibleOptions): React_2.RefObject<TElement | null>;

declare type UseFocusVisibleOptions = {
    targetDocument?: Document;
};

/**
 * A ponyfill that allows `:focus-within` to support visibility based on keyboard/mouse navigation
 * like `:focus-visible` https://github.com/WICG/focus-visible/issues/151
 * @returns ref to the element that uses `:focus-within` styles
 */
export declare function useFocusWithin<TElement extends HTMLElement = HTMLElement>(): React_2.RefObject<TElement | null>;

/**
 * Instantiates [keyborg](https://github.com/microsoft/keyborg) and checks if the user is navigating with the keyboard.
 * @returns
 */
export declare function useIsNavigatingWithKeyboard(): () => boolean;

/**
 * Instantiates [keyborg](https://github.com/microsoft/keyborg) and adds `data-keyboard-nav`
 * attribute to a referenced element to ensure keyboard navigation awareness
 * synced to keyborg logic without having to cause a re-render on react tree.
 */
export declare function useKeyboardNavAttribute<E extends HTMLElement>(): React_2.RefObject<E | null>;

/**
 * Merges a collection of tabster attributes.
 *
 * ⚠️The attributes passed as arguments to this  hook cannot change at runtime.
 * @internal
 * @param attributes - collection of tabster attributes from other react-tabster hooks
 * @returns single merged tabster attribute
 */
export declare const useMergedTabsterAttributes_unstable: (...attributes: (Partial<Types.TabsterDOMAttribute> | null | undefined)[]) => Types.TabsterDOMAttribute;

/**
 * Applies modal dialog behaviour through DOM attributes
 * Modal element will focus trap and hide other content on the page
 * The trigger element will be focused if focus is lost after the modal element is removed
 *
 * @returns DOM attributes to apply to the modal element and its trigger
 */
export declare const useModalAttributes: (options?: UseModalAttributesOptions) => {
    modalAttributes: Types.TabsterDOMAttribute;
    triggerAttributes: Types.TabsterDOMAttribute;
};

export declare interface UseModalAttributesOptions {
    /**
     * Traps focus inside the elements the attributes are applied.
     * it forbids users to tab out of the focus trap into the actual browser.
     */
    trapFocus?: boolean;
    /**
     * Traps focus inside the elements the attributes are applied.
     * This prop enables traditional force-focus behavior to match previous versions of Fluent.
     * Without this, users can tab out of the focus trap and into the browser chrome.
     * This matches the behavior of the native <dialog> element and inert.
     * We recommend setting this to true based on user feedback and consistency.
     */
    legacyTrapFocus?: boolean;
    /**
     * Always reachabled in Tab order
     */
    alwaysFocusable?: boolean;
    /**
     * Id to use for the modalizer. An id will be generated if not provided.
     */
    id?: string;
}

export declare function useObservedElement(name: string | string[]): Types.TabsterDOMAttribute;

/**
 * Instantiates [keyborg](https://github.com/microsoft/keyborg) and subscribes to changes
 * in the keyboard navigation mode.
 *
 * @param callback - called every time the keyboard navigation state changes
 */
export declare function useOnKeyboardNavigationChange(callback: (isNavigatingWithKeyboard: boolean) => void): void;

/**
 * Focus will be restored to the most recent target element when it is lost from a source
 * @returns Attribute to apply to the element that might lose focus
 */
export declare function useRestoreFocusSource(): Types.TabsterDOMAttribute;

/**
 * Focus will be restored to the most recent target element when it is lost from a source
 * @returns Attribute to apply to the target element where focus is restored
 */
export declare function useRestoreFocusTarget(): Types.TabsterDOMAttribute;

/**
 */
export declare function useSetKeyboardNavigation(): (isNavigatingWithKeyboard: boolean) => void;

/**
 * @internal
 * Hook that returns tabster attributes while ensuring tabster exists
 */
export declare const useTabsterAttributes: (props: Types.TabsterAttributeProps) => Types.TabsterDOMAttribute;

/**
 * Designates an area where tabster does not control focus
 * @returns Attribute to apply to the target element that should be uncontrolled by tabster
 */
export declare function useUncontrolledFocus(): Types.TabsterDOMAttribute;

declare interface Visibilities {
    Invisible: 0;
    PartiallyVisible: 1;
    Visible: 2;
}

declare const Visibilities: Visibilities;

declare type Visibility = Visibilities[keyof Visibilities];

declare interface WeakHTMLElement<D = undefined> {
    get(): HTMLElement | undefined;
    getData(): D | undefined;
}

export { }
