'use client';

import { __styles, mergeClasses, shorthands } from '@griffel/react';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
import { tokens, typographyStyles } from '@fluentui/react-theme';
import { useTabAnimatedIndicatorStyles_unstable } from './useTabAnimatedIndicator.styles';
export const tabClassNames = {
  root: 'fui-Tab',
  icon: 'fui-Tab__icon',
  content: 'fui-Tab__content'
};
export const tabReservedSpaceClassNames = {
  content: 'fui-Tab__content--reserved-space'
};
// These should match the constants defined in @fluentui/react-icons
// This package avoids taking a dependency on the icons package for only the constants.
const iconClassNames = {
  filled: 'fui-Icon-filled',
  regular: 'fui-Icon-regular'
};
/**
 * Styles for the root slot
 */
const useRootStyles = /*#__PURE__*/__styles({
  root: {
    Bt984gj: "f122n59",
    mc9l5x: "f13qh94s",
    Bnnss6s: "fi64zpg",
    Bxotwcr: "f1u07yai",
    Budl1dq: "frn2hmy",
    wkccdc: "f1olsevy",
    oeaueh: "f1s6fcnf",
    qhf8xq: "f10pi13n"
  },
  button: {
    Bt984gj: "f122n59",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f3bhgqh",
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5",
    Bceei9c: "f1k6fduh",
    mc9l5x: "f13qh94s",
    Bnnss6s: "fi64zpg",
    Bxotwcr: "f1u07yai",
    Budl1dq: "frn2hmy",
    wkccdc: "f1olsevy",
    Bahqtrf: "fk6fouc",
    Bg96gwp: "f1i3iumi",
    oeaueh: "f1s6fcnf",
    qhf8xq: "f10pi13n",
    B68tc82: 0,
    Bmxbyg5: 0,
    Bpg54ce: "f1a3p1vp",
    B9bfxx9: "f1cxpek8"
  },
  horizontal: {
    Brf1p80: "f4d9j23"
  },
  vertical: {
    Brf1p80: "f1s9ku6b"
  },
  smallHorizontal: {
    i8kkvl: "f14mj54c",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1wmopi4"
  },
  smallVertical: {
    i8kkvl: "f14mj54c",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f12or63q"
  },
  mediumHorizontal: {
    i8kkvl: "f1rjii52",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1w08f2p"
  },
  mediumVertical: {
    i8kkvl: "f1rjii52",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "fymxs25"
  },
  largeHorizontal: {
    i8kkvl: "f1rjii52",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1ssfvub"
  },
  largeVertical: {
    i8kkvl: "f1rjii52",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "fwkd1rq"
  },
  transparent: {
    De3pzq: "f1c21dwh",
    B95qlz1: "f9rvdkv",
    B7xitij: "f1051ucx",
    Bptxc3x: "fmmjozx",
    Bwqhzpy: "fqhzt5g",
    iyk698: "f7l5cgy",
    cl4aha: "fpkze5g",
    B0q3jbp: "f1iywnoi",
    Be9ayug: "f9n45c4"
  },
  subtle: {
    De3pzq: "fhovq9v",
    B95qlz1: "f1bifk9c",
    B7xitij: "fo6hitd",
    Bptxc3x: "fmmjozx",
    Bwqhzpy: "fqhzt5g",
    iyk698: "f7l5cgy",
    cl4aha: "fpkze5g",
    B0q3jbp: "f1iywnoi",
    Be9ayug: "f9n45c4"
  },
  disabledCursor: {
    Bceei9c: "fdrzuqr"
  },
  disabled: {
    De3pzq: "f1c21dwh",
    Bptxc3x: "fato7r6",
    cl4aha: "fao1bnu"
  },
  selected: {
    Bptxc3x: "f1cadz5z",
    Bwqhzpy: "fwhdxxj",
    iyk698: "fintccb",
    cl4aha: "ffplhdr",
    B0q3jbp: "fjo17wb",
    Be9ayug: "f148789c"
  }
}, {
  d: [".f122n59{align-items:center;}", ".f13qh94s{display:grid;}", ".fi64zpg{flex-shrink:0;}", ".f1u07yai{grid-auto-flow:column;}", ".frn2hmy{grid-template-columns:auto;}", ".f1olsevy{grid-template-rows:auto;}", ".f1s6fcnf{outline-style:none;}", ".f10pi13n{position:relative;}", [".f3bhgqh{border:none;}", {
    p: -2
  }], [".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], ".f1k6fduh{cursor:pointer;}", ".fk6fouc{font-family:var(--fontFamilyBase);}", ".f1i3iumi{line-height:var(--lineHeightBase300);}", [".f1a3p1vp{overflow:hidden;}", {
    p: -1
  }], ".f1cxpek8{text-transform:none;}", ".f4d9j23{justify-content:center;}", ".f1s9ku6b{justify-content:start;}", ".f14mj54c{column-gap:var(--spacingHorizontalXXS);}", [".f1wmopi4{padding:var(--spacingVerticalSNudge) var(--spacingHorizontalSNudge);}", {
    p: -1
  }], [".f12or63q{padding:var(--spacingVerticalXXS) var(--spacingHorizontalSNudge);}", {
    p: -1
  }], ".f1rjii52{column-gap:var(--spacingHorizontalSNudge);}", [".f1w08f2p{padding:var(--spacingVerticalM) var(--spacingHorizontalMNudge);}", {
    p: -1
  }], [".fymxs25{padding:var(--spacingVerticalSNudge) var(--spacingHorizontalMNudge);}", {
    p: -1
  }], [".f1ssfvub{padding:var(--spacingVerticalL) var(--spacingHorizontalMNudge);}", {
    p: -1
  }], [".fwkd1rq{padding:var(--spacingVerticalS) var(--spacingHorizontalMNudge);}", {
    p: -1
  }], ".f1c21dwh{background-color:var(--colorTransparentBackground);}", ".f9rvdkv:enabled:hover{background-color:var(--colorTransparentBackgroundHover);}", ".f1051ucx:enabled:active{background-color:var(--colorTransparentBackgroundPressed);}", ".fmmjozx .fui-Tab__icon{color:var(--colorNeutralForeground2);}", ".fqhzt5g:enabled:hover .fui-Tab__icon{color:var(--colorNeutralForeground2Hover);}", ".f7l5cgy:enabled:active .fui-Tab__icon{color:var(--colorNeutralForeground2Pressed);}", ".fpkze5g .fui-Tab__content{color:var(--colorNeutralForeground2);}", ".f1iywnoi:enabled:hover .fui-Tab__content{color:var(--colorNeutralForeground2Hover);}", ".f9n45c4:enabled:active .fui-Tab__content{color:var(--colorNeutralForeground2Pressed);}", ".fhovq9v{background-color:var(--colorSubtleBackground);}", ".f1bifk9c:enabled:hover{background-color:var(--colorSubtleBackgroundHover);}", ".fo6hitd:enabled:active{background-color:var(--colorSubtleBackgroundPressed);}", ".fdrzuqr{cursor:not-allowed;}", ".fato7r6 .fui-Tab__icon{color:var(--colorNeutralForegroundDisabled);}", ".fao1bnu .fui-Tab__content{color:var(--colorNeutralForegroundDisabled);}", ".f1cadz5z .fui-Tab__icon{color:var(--colorCompoundBrandForeground1);}", ".fwhdxxj:enabled:hover .fui-Tab__icon{color:var(--colorCompoundBrandForeground1Hover);}", ".fintccb:enabled:active .fui-Tab__icon{color:var(--colorCompoundBrandForeground1Pressed);}", ".ffplhdr .fui-Tab__content{color:var(--colorNeutralForeground1);}", ".fjo17wb:enabled:hover .fui-Tab__content{color:var(--colorNeutralForeground1Hover);}", ".f148789c:enabled:active .fui-Tab__content{color:var(--colorNeutralForeground1Pressed);}"]
});
const useCircularAppearanceStyles = /*#__PURE__*/__styles({
  base: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "f44lkw9",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "fp7rvkm",
    Bptxc3x: "ftorr8m",
    cl4aha: "f16lqpmv"
  },
  small: {
    Dbcxam: 0,
    rjzwhg: 0,
    Bblux5w: "fzklhed"
  },
  medium: {
    Dbcxam: 0,
    rjzwhg: 0,
    Bblux5w: "f1j721cc"
  },
  large: {
    Dbcxam: 0,
    rjzwhg: 0,
    Bblux5w: "frx9knr"
  },
  subtle: {
    De3pzq: "fhovq9v",
    sj55zd: "fkfq4zb",
    B95qlz1: "f1bifk9c",
    Eo63ln: 0,
    r9osk6: 0,
    Itrz8y: 0,
    zeg6vx: 0,
    l65xgk: 0,
    Bw4olcx: 0,
    Folb0i: 0,
    I2h8y4: 0,
    Bgxgoyi: 0,
    Bvlkotb: 0,
    Fwyncl: 0,
    Byh5edv: 0,
    Becqvjq: 0,
    uumbiq: 0,
    B73q3dg: 0,
    Bblwbaf: 0,
    B0ezav: "ft57sj0",
    r4wkhp: "f1fcoy83",
    B7xitij: "fo6hitd",
    d3wsvi: 0,
    Hdqn7s: 0,
    zu5y1p: 0,
    owqphb: 0,
    g9c53k: 0,
    Btmu08z: 0,
    Bthxvy6: 0,
    gluvuq: 0,
    tb88gp: 0,
    wns6jk: 0,
    kdfdk4: 0,
    Bbw008l: 0,
    Bayi1ib: 0,
    B1kkfu3: 0,
    J1oqyp: 0,
    kem6az: 0,
    goa3yj: "fhn220o",
    p743kt: "f15qf7sh",
    uu68id: 0,
    Bxeuatn: 0,
    felo30: 0,
    Bc736ss: 0,
    Bhz882k: 0,
    n51gp8: 0,
    Eshu5l: 0,
    Bk6ri7n: 0,
    v49c4f: 0,
    Bn1d65q: 0,
    c4eypz: 0,
    v3aym: 0,
    hft9gk: 0,
    Bjwas2f: 0,
    Bk5ld8o: 0,
    gwxt9v: 0,
    B6k8go: "f130w16x"
  },
  subtleSelected: {
    De3pzq: "f16xkysk",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f1c2pc3t",
    sj55zd: "faj9fo0",
    B95qlz1: "fsm7zmf",
    Eo63ln: 0,
    r9osk6: 0,
    Itrz8y: 0,
    zeg6vx: 0,
    l65xgk: 0,
    Bw4olcx: 0,
    Folb0i: 0,
    I2h8y4: 0,
    Bgxgoyi: 0,
    Bvlkotb: 0,
    Fwyncl: 0,
    Byh5edv: 0,
    Becqvjq: 0,
    uumbiq: 0,
    B73q3dg: 0,
    Bblwbaf: 0,
    B0ezav: "f1wo0sfq",
    r4wkhp: "f1afuynh",
    B7xitij: "f94ddyl",
    d3wsvi: 0,
    Hdqn7s: 0,
    zu5y1p: 0,
    owqphb: 0,
    g9c53k: 0,
    Btmu08z: 0,
    Bthxvy6: 0,
    gluvuq: 0,
    tb88gp: 0,
    wns6jk: 0,
    kdfdk4: 0,
    Bbw008l: 0,
    Bayi1ib: 0,
    B1kkfu3: 0,
    J1oqyp: 0,
    kem6az: 0,
    goa3yj: "fmle6oo",
    p743kt: "f1d3itm4",
    uu68id: 0,
    Bxeuatn: 0,
    felo30: 0,
    Bc736ss: 0,
    Bhz882k: 0,
    n51gp8: 0,
    Eshu5l: 0,
    Bk6ri7n: 0,
    v49c4f: 0,
    Bn1d65q: 0,
    c4eypz: 0,
    v3aym: 0,
    hft9gk: 0,
    Bjwas2f: 0,
    Bk5ld8o: 0,
    gwxt9v: 0,
    B6k8go: "f19qjb1h"
  },
  subtleDisabled: {
    De3pzq: "fhovq9v",
    sj55zd: "f1s2aq7o"
  },
  subtleDisabledSelected: {
    De3pzq: "f1bg9a2p",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "fegtqic",
    sj55zd: "f1s2aq7o"
  },
  filled: {
    De3pzq: "f16xq7d1",
    sj55zd: "fkfq4zb",
    B95qlz1: "fwwxidx",
    r4wkhp: "f1fcoy83",
    B7xitij: "f14i52sd",
    p743kt: "f15qf7sh",
    Bw5j0gk: "f159yq2d",
    Baikq8m: "ful0ncq",
    B2ndh17: "f2rulcp",
    w0x64w: "f19p5z4e",
    Bdzpij4: "fo1bcu3"
  },
  filledSelected: {
    De3pzq: "ffp7eso",
    sj55zd: "f1phragk",
    B95qlz1: "f1lm9dni",
    r4wkhp: "f1mn5ei1",
    B7xitij: "f1g6ncd0",
    p743kt: "fl71aob",
    bml8oc: "f13s88zn",
    qew46a: "f16zjd40",
    B84x17g: "f1mr3uue",
    Jetwu1: "f196ywdt"
  },
  filledDisabled: {
    De3pzq: "f1bg9a2p",
    sj55zd: "f1s2aq7o"
  },
  filledDisabledSelected: {
    De3pzq: "f1bg9a2p",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "fegtqic",
    sj55zd: "f1s2aq7o"
  }
}, {
  d: [[".f44lkw9{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], [".fp7rvkm{border:solid var(--strokeWidthThin) var(--colorTransparentStroke);}", {
    p: -2
  }], ".ftorr8m .fui-Tab__icon{color:inherit;}", ".f16lqpmv .fui-Tab__content{color:inherit;}", [".fzklhed{padding-block:calc(var(--spacingVerticalXXS) - var(--strokeWidthThin));}", {
    p: -1
  }], [".f1j721cc{padding-block:calc(var(--spacingVerticalSNudge) - var(--strokeWidthThin));}", {
    p: -1
  }], [".frx9knr{padding-block:calc(var(--spacingVerticalS) - var(--strokeWidthThin));}", {
    p: -1
  }], ".fhovq9v{background-color:var(--colorSubtleBackground);}", ".fkfq4zb{color:var(--colorNeutralForeground2);}", ".f1bifk9c:enabled:hover{background-color:var(--colorSubtleBackgroundHover);}", [".ft57sj0:enabled:hover{border:solid var(--strokeWidthThin) var(--colorNeutralStroke1Hover);}", {
    p: -2
  }], ".f1fcoy83:enabled:hover{color:var(--colorNeutralForeground2Hover);}", ".fo6hitd:enabled:active{background-color:var(--colorSubtleBackgroundPressed);}", [".fhn220o:enabled:active{border:solid var(--strokeWidthThin) var(--colorNeutralStroke1Pressed);}", {
    p: -2
  }], ".f15qf7sh:enabled:active{color:var(--colorNeutralForeground2Pressed);}", ".f16xkysk{background-color:var(--colorBrandBackground2);}", [".f1c2pc3t{border:solid var(--strokeWidthThin) var(--colorCompoundBrandStroke);}", {
    p: -2
  }], ".faj9fo0{color:var(--colorBrandForeground2);}", ".fsm7zmf:enabled:hover{background-color:var(--colorBrandBackground2Hover);}", [".f1wo0sfq:enabled:hover{border:solid var(--strokeWidthThin) var(--colorCompoundBrandStrokeHover);}", {
    p: -2
  }], ".f1afuynh:enabled:hover{color:var(--colorBrandForeground2Hover);}", ".f94ddyl:enabled:active{background-color:var(--colorBrandBackground2Pressed);}", [".fmle6oo:enabled:active{border:solid var(--strokeWidthThin) var(--colorCompoundBrandStrokePressed);}", {
    p: -2
  }], ".f1d3itm4:enabled:active{color:var(--colorBrandForeground2Pressed);}", ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}", ".f1bg9a2p{background-color:var(--colorNeutralBackgroundDisabled);}", [".fegtqic{border:solid var(--strokeWidthThin) var(--colorNeutralStrokeDisabled);}", {
    p: -2
  }], ".f16xq7d1{background-color:var(--colorNeutralBackground3);}", ".fwwxidx:enabled:hover{background-color:var(--colorNeutralBackground3Hover);}", ".f14i52sd:enabled:active{background-color:var(--colorNeutralBackground3Pressed);}", ".ffp7eso{background-color:var(--colorBrandBackground);}", ".f1phragk{color:var(--colorNeutralForegroundOnBrand);}", ".f1lm9dni:enabled:hover{background-color:var(--colorBrandBackgroundHover);}", ".f1mn5ei1:enabled:hover{color:var(--colorNeutralForegroundOnBrand);}", ".f1g6ncd0:enabled:active{background-color:var(--colorBrandBackgroundPressed);}", ".fl71aob:enabled:active{color:var(--colorNeutralForegroundOnBrand);}", [".fegtqic{border:solid var(--strokeWidthThin) var(--colorNeutralStrokeDisabled);}", {
    p: -2
  }]],
  m: [["@media (forced-colors: active){.f130w16x{border:solid var(--strokeWidthThin) Canvas;}}", {
    p: -2,
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f19qjb1h{border:solid var(--strokeWidthThin) Highlight;}}", {
    p: -2,
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f159yq2d:enabled:hover{background-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.ful0ncq:enabled:hover{forced-color-adjust:none;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f2rulcp:enabled:hover .fui-Tab__content{color:HighlightText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f19p5z4e:enabled:hover .fui-Icon-filled{color:HighlightText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.fo1bcu3:enabled:hover .fui-Icon-regular{color:HighlightText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f13s88zn:enabled{background-color:ButtonText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f16zjd40:enabled .fui-Tab__content{color:ButtonFace;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1mr3uue:enabled .fui-Tab__content{forced-color-adjust:none;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f196ywdt:enabled .fui-Tab__icon{color:ButtonFace;}}", {
    m: "(forced-colors: active)"
  }]]
});
/**
 * Focus styles for the root slot
 */
const useFocusStyles = /*#__PURE__*/__styles({
  base: {
    B8q5s1w: "f8hki3x",
    Bci5o5g: ["f1d2448m", "ffh67wi"],
    n8qw10: "f1bjia2o",
    Bdrgwmp: ["ffh67wi", "f1d2448m"],
    Bn4voq9: "f1p7hgxw",
    Bfpq7zp: "f1way5bb",
    g9k6zt: "f9znhxp",
    j6ew2k: ["fqa318h", "fqa318h"],
    Bhxq17a: "f1vjpng2"
  },
  circular: {
    B8q5s1w: "f8hki3x",
    Bci5o5g: ["f1d2448m", "ffh67wi"],
    n8qw10: "f1bjia2o",
    Bdrgwmp: ["ffh67wi", "f1d2448m"],
    Bn4voq9: "f1p7hgxw",
    Bfpq7zp: "f1way5bb",
    g9k6zt: "f9znhxp",
    j6ew2k: ["fzgyhws", "fqxug60"],
    Bhxq17a: "f1vjpng2"
  }
}, {
  d: [".f8hki3x[data-fui-focus-visible]{border-top-color:transparent;}", ".f1d2448m[data-fui-focus-visible]{border-right-color:transparent;}", ".ffh67wi[data-fui-focus-visible]{border-left-color:transparent;}", ".f1bjia2o[data-fui-focus-visible]{border-bottom-color:transparent;}", ".f1p7hgxw[data-fui-focus-visible]{outline-width:var(--strokeWidthThick);}", ".f1way5bb[data-fui-focus-visible]{outline-color:transparent;}", ".f9znhxp[data-fui-focus-visible]{outline-style:solid;}", ".fqa318h[data-fui-focus-visible]{box-shadow:var(--shadow4),0 0 0 var(--strokeWidthThick) var(--colorStrokeFocus2);}", ".f1vjpng2[data-fui-focus-visible]{z-index:1;}", ".fzgyhws[data-fui-focus-visible]{box-shadow:var(--shadow4),0 0 0 var(--strokeWidthThick) var(--colorStrokeFocus2),0 0 0 var(--strokeWidthThin) var(--colorNeutralStrokeOnBrand) inset;}", ".fqxug60[data-fui-focus-visible]{box-shadow:var(--shadow4),0 0 0 var(--strokeWidthThick) var(--colorStrokeFocus2),0 0 0 var(--strokeWidthThin) var(--colorNeutralStrokeOnBrand) inset;}"]
});
/** Indicator styles for when pending selection */
const usePendingIndicatorStyles = /*#__PURE__*/__styles({
  base: {
    az7l2e: "fhw179n",
    vqofr: 0,
    Bv4n3vi: 0,
    Bgqb9hq: 0,
    B0uxbk8: 0,
    Bf3jju6: "fg9j5n4",
    amg5m6: "f1kmhr4c",
    zkfqfm: "fl1ydde",
    Bkydozb: "f1y7maxz",
    Bka2azo: 0,
    vzq8l0: 0,
    csmgbd: 0,
    Br4ovkg: 0,
    aelrif: "fceyvr4",
    y36c18: "f16cxu0",
    B1ctymy: "f1nwgacf",
    Bgvrrv0: "f15ovonk",
    ddr6p5: "fvje46l"
  },
  disabled: {
    az7l2e: "f1ut20fw",
    Bkydozb: "fhrzcfn",
    Bgvrrv0: "f1v15rkt",
    ddr6p5: "f3nwrnk"
  },
  smallHorizontal: {
    lawp4y: "fchca7p",
    Baz25je: "f1r53b5e",
    Fbdkly: ["f1s6rxz5", "fo35v8s"],
    mdwyqc: ["fo35v8s", "f1s6rxz5"]
  },
  smallVertical: {
    lawp4y: "fze4zud",
    Fbdkly: ["f1fzr1x6", "f1f351id"],
    Bciustq: "fdp32p8",
    Ccq8qp: "f1aij3q"
  },
  mediumHorizontal: {
    lawp4y: "fchca7p",
    Baz25je: "f1s2r9ax",
    Fbdkly: ["f1o0nnkk", "fxb7rol"],
    mdwyqc: ["fxb7rol", "f1o0nnkk"]
  },
  mediumVertical: {
    lawp4y: "f17jracn",
    Fbdkly: ["f1fzr1x6", "f1f351id"],
    Bciustq: "f117lcb2",
    Ccq8qp: "f1aij3q"
  },
  largeHorizontal: {
    lawp4y: "fchca7p",
    Baz25je: "f1s2r9ax",
    Fbdkly: ["f1o0nnkk", "fxb7rol"],
    mdwyqc: ["fxb7rol", "f1o0nnkk"]
  },
  largeVertical: {
    lawp4y: "fel9d3z",
    Fbdkly: ["f1fzr1x6", "f1f351id"],
    Bciustq: "f6vqlre",
    Ccq8qp: "f1aij3q"
  }
}, {
  h: [".fhw179n:hover::before{background-color:var(--colorNeutralStroke1Hover);}", [".fg9j5n4:hover::before{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], ".f1kmhr4c:hover::before{content:\"\";}", ".fl1ydde:hover::before{position:absolute;}", ".f1ut20fw:hover::before{background-color:var(--colorTransparentStroke);}"],
  a: [".f1y7maxz:active::before{background-color:var(--colorNeutralStroke1Pressed);}", [".fceyvr4:active::before{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], ".f16cxu0:active::before{content:\"\";}", ".f1nwgacf:active::before{position:absolute;}", ".fhrzcfn:active::before{background-color:var(--colorTransparentStroke);}"],
  m: [["@media (forced-colors: active){.f15ovonk:hover::before{background-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.fvje46l:active::before{background-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1v15rkt:hover::before{background-color:transparent;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f3nwrnk:active::before{background-color:transparent;}}", {
    m: "(forced-colors: active)"
  }]],
  d: [".fchca7p::before{bottom:0;}", ".f1r53b5e::before{height:var(--strokeWidthThick);}", ".f1s6rxz5::before{left:var(--spacingHorizontalSNudge);}", ".fo35v8s::before{right:var(--spacingHorizontalSNudge);}", ".fze4zud::before{bottom:var(--spacingVerticalXS);}", ".f1fzr1x6::before{left:0;}", ".f1f351id::before{right:0;}", ".fdp32p8::before{top:var(--spacingVerticalXS);}", ".f1aij3q::before{width:var(--strokeWidthThicker);}", ".f1s2r9ax::before{height:var(--strokeWidthThicker);}", ".f1o0nnkk::before{left:var(--spacingHorizontalM);}", ".fxb7rol::before{right:var(--spacingHorizontalM);}", ".f17jracn::before{bottom:var(--spacingVerticalS);}", ".f117lcb2::before{top:var(--spacingVerticalS);}", ".fel9d3z::before{bottom:var(--spacingVerticalMNudge);}", ".f6vqlre::before{top:var(--spacingVerticalMNudge);}"]
});
const useActiveIndicatorStyles = /*#__PURE__*/__styles({
  base: {
    Bjyk6c5: "f1rp0jgh",
    d9w3h3: 0,
    B3778ie: 0,
    B4j8arr: 0,
    Bl18szs: 0,
    Blrzh8d: "f3b9emi",
    Bsft5z2: "f13zj6fq",
    E3zdtr: "f1mdlcz9"
  },
  selected: {
    Bjyk6c5: "f1ksivud",
    Bej4dhw: "f1476jrx",
    B7wqxwa: "f18q216b",
    f7digc: "fy7ktjt",
    Bvuzv5k: "f1033yux",
    k4sdgo: "fkh9b8o"
  },
  disabled: {
    Bjyk6c5: "f13lkzet"
  },
  smallHorizontal: {
    By385i5: "fo72kxq",
    Dlnsje: "f9bb2ob",
    Eqx8gd: ["f1q70ajw", "f18rbzdx"],
    B1piin3: ["f18rbzdx", "f1q70ajw"]
  },
  smallVertical: {
    By385i5: "fqbue9b",
    Eqx8gd: ["f1n6gb5g", "f15yvnhg"],
    bn5sak: "fk1klkt",
    a2br6o: "f1o25lip"
  },
  mediumHorizontal: {
    By385i5: "fo72kxq",
    Dlnsje: "f1vx7lu8",
    Eqx8gd: ["fna7m5n", "f1oxpfwv"],
    B1piin3: ["f1oxpfwv", "fna7m5n"]
  },
  mediumVertical: {
    By385i5: "fipylg0",
    Eqx8gd: ["f1n6gb5g", "f15yvnhg"],
    bn5sak: "fqchiol",
    a2br6o: "f1o25lip"
  },
  largeHorizontal: {
    By385i5: "fo72kxq",
    Dlnsje: "f1vx7lu8",
    Eqx8gd: ["fna7m5n", "f1oxpfwv"],
    B1piin3: ["f1oxpfwv", "fna7m5n"]
  },
  largeVertical: {
    By385i5: "f1w7dm5g",
    Eqx8gd: ["f1n6gb5g", "f15yvnhg"],
    bn5sak: "f1p6em4m",
    a2br6o: "f1o25lip"
  }
}, {
  d: [".f1rp0jgh::after{background-color:var(--colorTransparentStroke);}", [".f3b9emi::after{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], ".f13zj6fq::after{content:\"\";}", ".f1mdlcz9::after{position:absolute;}", ".f1ksivud::after{background-color:var(--colorCompoundBrandStroke);}", ".f1476jrx:enabled:hover::after{background-color:var(--colorCompoundBrandStrokeHover);}", ".f18q216b:enabled:active::after{background-color:var(--colorCompoundBrandStrokePressed);}", ".f13lkzet::after{background-color:var(--colorNeutralForegroundDisabled);}", ".fo72kxq::after{bottom:0;}", ".f9bb2ob::after{height:var(--strokeWidthThick);}", ".f1q70ajw::after{left:var(--spacingHorizontalSNudge);}", ".f18rbzdx::after{right:var(--spacingHorizontalSNudge);}", ".fqbue9b::after{bottom:var(--spacingVerticalXS);}", ".f1n6gb5g::after{left:0;}", ".f15yvnhg::after{right:0;}", ".fk1klkt::after{top:var(--spacingVerticalXS);}", ".f1o25lip::after{width:var(--strokeWidthThicker);}", ".f1vx7lu8::after{height:var(--strokeWidthThicker);}", ".fna7m5n::after{left:var(--spacingHorizontalM);}", ".f1oxpfwv::after{right:var(--spacingHorizontalM);}", ".fipylg0::after{bottom:var(--spacingVerticalS);}", ".fqchiol::after{top:var(--spacingVerticalS);}", ".f1w7dm5g::after{bottom:var(--spacingVerticalMNudge);}", ".f1p6em4m::after{top:var(--spacingVerticalMNudge);}"],
  m: [["@media (forced-colors: active){.fy7ktjt::after{background-color:ButtonText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1033yux:enabled:hover::after{background-color:ButtonText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.fkh9b8o:enabled:active::after{background-color:ButtonText;}}", {
    m: "(forced-colors: active)"
  }]]
});
/**
 * Styles for the icon slot.
 */
const useIconStyles = /*#__PURE__*/__styles({
  base: {
    Br312pm: "fwpfdsa",
    Ijaq50: "f16hsg94",
    Bt984gj: "f122n59",
    mc9l5x: "ftuwxu6",
    Brf1p80: "f4d9j23",
    B68tc82: 0,
    Bmxbyg5: 0,
    Bpg54ce: "f1a3p1vp",
    D0sxk3: "f16u1re",
    t6yez3: "f8bsbmo"
  },
  small: {
    Be2twd7: "fe5j1ua",
    Bqenvij: "fjamq6b",
    a9b677: "f64fuq3"
  },
  medium: {
    Be2twd7: "fe5j1ua",
    Bqenvij: "fjamq6b",
    a9b677: "f64fuq3"
  },
  large: {
    Be2twd7: "f1rt2boy",
    Bqenvij: "frvgh55",
    a9b677: "fq4mcun"
  },
  selected: {
    D0sxk3: "fxoiby5",
    t6yez3: "f15q0o9g"
  }
}, {
  d: [".fwpfdsa{grid-column-start:1;}", ".f16hsg94{grid-row-start:1;}", ".f122n59{align-items:center;}", ".ftuwxu6{display:inline-flex;}", ".f4d9j23{justify-content:center;}", [".f1a3p1vp{overflow:hidden;}", {
    p: -1
  }], ".f16u1re .fui-Icon-filled{display:none;}", ".f8bsbmo .fui-Icon-regular{display:inline;}", ".fe5j1ua{font-size:20px;}", ".fjamq6b{height:20px;}", ".f64fuq3{width:20px;}", ".f1rt2boy{font-size:24px;}", ".frvgh55{height:24px;}", ".fq4mcun{width:24px;}", ".fxoiby5 .fui-Icon-filled{display:inline;}", ".f15q0o9g .fui-Icon-regular{display:none;}"]
});
/**
 * Styles for the content slot (children)
 */
const useContentStyles = /*#__PURE__*/__styles({
  base: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fkhj508",
    Bhrd7zp: "figsok6",
    Bg96gwp: "f1i3iumi",
    B68tc82: 0,
    Bmxbyg5: 0,
    Bpg54ce: "f1a3p1vp",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1bwptpd"
  },
  selected: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fkhj508",
    Bhrd7zp: "fl43uef",
    Bg96gwp: "f1i3iumi"
  },
  large: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fod5ikn",
    Bhrd7zp: "figsok6",
    Bg96gwp: "faaz57k"
  },
  largeSelected: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fod5ikn",
    Bhrd7zp: "fl43uef",
    Bg96gwp: "faaz57k"
  },
  noIconBefore: {
    Br312pm: "fwpfdsa",
    Ijaq50: "f16hsg94"
  },
  iconBefore: {
    Br312pm: "fd46tj4",
    Ijaq50: "f16hsg94"
  },
  placeholder: {
    Bcdw1i0: "fd7fpy0"
  }
}, {
  d: [".fk6fouc{font-family:var(--fontFamilyBase);}", ".fkhj508{font-size:var(--fontSizeBase300);}", ".figsok6{font-weight:var(--fontWeightRegular);}", ".f1i3iumi{line-height:var(--lineHeightBase300);}", [".f1a3p1vp{overflow:hidden;}", {
    p: -1
  }], [".f1bwptpd{padding:var(--spacingVerticalNone) var(--spacingHorizontalXXS);}", {
    p: -1
  }], ".fl43uef{font-weight:var(--fontWeightSemibold);}", ".fod5ikn{font-size:var(--fontSizeBase400);}", ".faaz57k{line-height:var(--lineHeightBase400);}", ".fwpfdsa{grid-column-start:1;}", ".f16hsg94{grid-row-start:1;}", ".fd46tj4{grid-column-start:2;}", ".fd7fpy0{visibility:hidden;}"]
});
/**
 * Apply styling to the Tab slots based on the state
 */
export const useTabStyles_unstable = state => {
  'use no memo';

  useTabIndicatorStyles_unstable(state);
  useTabButtonStyles_unstable(state, state.root);
  useTabContentStyles_unstable(state);
  return state;
};
/**
 * Applies styles for the Tab indicator based on its current state.
 *
 * This hook is typically used internally by `useTabStyles_unstable`. You should
 * only use it directly if you're creating a custom `Tab` component.
 *
 * @param state - The `Tab` component's current state
 * @returns The state object with updated button styles
 */
export const useTabIndicatorStyles_unstable = state => {
  'use no memo';

  const rootStyles = useRootStyles();
  const pendingIndicatorStyles = usePendingIndicatorStyles();
  const activeIndicatorStyles = useActiveIndicatorStyles();
  const {
    appearance,
    disabled,
    selected,
    size,
    vertical
  } = state;
  const classes = [tabClassNames.root, rootStyles.root];
  if (appearance !== 'subtle-circular' && appearance !== 'filled-circular') {
    classes.push(
    // pending indicator (before pseudo element)
    pendingIndicatorStyles.base, size === 'small' && (vertical ? pendingIndicatorStyles.smallVertical : pendingIndicatorStyles.smallHorizontal), size === 'medium' && (vertical ? pendingIndicatorStyles.mediumVertical : pendingIndicatorStyles.mediumHorizontal), size === 'large' && (vertical ? pendingIndicatorStyles.largeVertical : pendingIndicatorStyles.largeHorizontal), disabled && pendingIndicatorStyles.disabled,
    // active indicator (after pseudo element)
    selected && activeIndicatorStyles.base, selected && !disabled && activeIndicatorStyles.selected, selected && size === 'small' && (vertical ? activeIndicatorStyles.smallVertical : activeIndicatorStyles.smallHorizontal), selected && size === 'medium' && (vertical ? activeIndicatorStyles.mediumVertical : activeIndicatorStyles.mediumHorizontal), selected && size === 'large' && (vertical ? activeIndicatorStyles.largeVertical : activeIndicatorStyles.largeHorizontal), selected && disabled && activeIndicatorStyles.disabled);
  }
  state.root.className = mergeClasses(...classes, state.root.className);
  useTabAnimatedIndicatorStyles_unstable(state);
  return state;
};
/**
 * Applies styles to the Tab button slot based on its current state.
 *
 * This hook is typically used internally by `useTabStyles_unstable`. You should
 * only use it directly if you're creating a custom `Tab` component.
 *
 * @param state - The Tab component's current state
 * @param slot - The button slot of the Tab component
 * @returns The state object with updated button styles
 */
export const useTabButtonStyles_unstable = (state, slot) => {
  'use no memo';

  const rootStyles = useRootStyles();
  const focusStyles = useFocusStyles();
  const circularStyles = useCircularAppearanceStyles();
  const {
    appearance,
    disabled,
    selected,
    size,
    vertical
  } = state;
  const isSubtleCircular = appearance === 'subtle-circular';
  const isFilledCircular = appearance === 'filled-circular';
  const isCircular = isSubtleCircular || isFilledCircular;
  const circularAppearance = [circularStyles.base, focusStyles.circular,
  // sizes
  size === 'small' && circularStyles.small, size === 'medium' && circularStyles.medium, size === 'large' && circularStyles.large,
  // subtle-circular appearance
  isSubtleCircular && circularStyles.subtle, selected && isSubtleCircular && circularStyles.subtleSelected, disabled && isSubtleCircular && circularStyles.subtleDisabled, selected && disabled && isSubtleCircular && circularStyles.subtleDisabledSelected,
  // filled-circular appearance
  isFilledCircular && circularStyles.filled, selected && isFilledCircular && circularStyles.filledSelected, disabled && isFilledCircular && circularStyles.filledDisabled, selected && disabled && isFilledCircular && circularStyles.filledDisabledSelected];
  const regularAppearance = [focusStyles.base, !disabled && appearance === 'subtle' && rootStyles.subtle, !disabled && appearance === 'transparent' && rootStyles.transparent, !disabled && selected && rootStyles.selected, disabled && rootStyles.disabled];
  slot.className = mergeClasses(rootStyles.button,
  // orientation
  vertical ? rootStyles.vertical : rootStyles.horizontal,
  // size
  size === 'small' && (vertical ? rootStyles.smallVertical : rootStyles.smallHorizontal), size === 'medium' && (vertical ? rootStyles.mediumVertical : rootStyles.mediumHorizontal), size === 'large' && (vertical ? rootStyles.largeVertical : rootStyles.largeHorizontal), ...(isCircular ? circularAppearance : regularAppearance), disabled && rootStyles.disabledCursor, slot.className);
  return state;
};
/**
 * Applies styles to the Tab content slot based on its current state.
 *
 * This hook is typically used internally by `useTabStyles_unstable`. You should
 * only use it directly if you're creating a custom `Tab` component.
 *
 * @param state - The Tab component's current state
 * @returns The state object with updated content styles
 */
export const useTabContentStyles_unstable = state => {
  'use no memo';

  const iconStyles = useIconStyles();
  const contentStyles = useContentStyles();
  const {
    selected,
    size
  } = state;
  if (state.icon) {
    state.icon.className = mergeClasses(tabClassNames.icon, iconStyles.base, iconStyles[size], selected && iconStyles.selected, state.icon.className);
  }
  // This needs to be before state.content.className is updated
  if (state.contentReservedSpace) {
    state.contentReservedSpace.className = mergeClasses(tabReservedSpaceClassNames.content, contentStyles.base, size === 'large' ? contentStyles.largeSelected : contentStyles.selected, state.icon ? contentStyles.iconBefore : contentStyles.noIconBefore, contentStyles.placeholder, state.content.className);
    // FIXME: this is a deprecated API
    // should be removed in the next major version
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    state.contentReservedSpaceClassName = state.contentReservedSpace.className;
  }
  state.content.className = mergeClasses(tabClassNames.content, contentStyles.base, size === 'large' && contentStyles.large, selected && (size === 'large' ? contentStyles.largeSelected : contentStyles.selected), state.icon ? contentStyles.iconBefore : contentStyles.noIconBefore, state.content.className);
  return state;
};