'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tabListClassNames: function() {
        return tabListClassNames;
    },
    useTabListStyles_unstable: function() {
        return useTabListStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const tabListClassNames = {
    root: 'fui-TabList'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flexDirection: 'row',
        flexShrink: 0,
        flexWrap: 'nowrap',
        position: 'relative'
    },
    horizontal: {
        alignItems: 'stretch',
        flexDirection: 'row'
    },
    vertical: {
        alignItems: 'stretch',
        flexDirection: 'column'
    },
    roundedSmall: {
        gap: _reacttheme.tokens.spacingHorizontalSNudge
    },
    rounded: {
        gap: _reacttheme.tokens.spacingHorizontalS
    }
});
const useTabListStyles_unstable = (state)=>{
    'use no memo';
    const { appearance, vertical, size } = state;
    const styles = useStyles();
    const isRounded = appearance === 'subtle-circular' || appearance === 'filled-circular';
    state.root.className = (0, _react.mergeClasses)(tabListClassNames.root, styles.root, vertical ? styles.vertical : styles.horizontal, isRounded && (size === 'small' ? styles.roundedSmall : styles.rounded), state.root.className);
    return state;
};
