'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTabList_unstable", {
    enumerable: true,
    get: function() {
        return useTabList_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const useTabList_unstable = (props, ref)=>{
    const { appearance = 'transparent', reserveSelectedTabSpace = true, disabled = false, onTabSelect, selectTabOnFocus = false, size = 'medium', vertical = false } = props;
    const innerRef = _react.useRef(null);
    const focusAttributes = (0, _reacttabster.useArrowNavigationGroup)({
        circular: true,
        axis: vertical ? 'vertical' : 'horizontal',
        memorizeCurrent: false,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        unstable_hasDefault: true
    });
    const [selectedValue, setSelectedValue] = (0, _reactutilities.useControllableState)({
        state: props.selectedValue,
        defaultState: props.defaultSelectedValue,
        initialState: undefined
    });
    // considered usePrevious, but it is sensitive to re-renders
    // this could cause the previous to move to current in the case where the tab list re-renders.
    // these refs avoid getRegisteredTabs changing when selectedValue changes and causing
    // renders for tabs that have not changed.
    const currentSelectedValue = _react.useRef(undefined);
    const previousSelectedValue = _react.useRef(undefined);
    _react.useEffect(()=>{
        previousSelectedValue.current = currentSelectedValue.current;
        currentSelectedValue.current = selectedValue;
    }, [
        selectedValue
    ]);
    const onSelect = (0, _reactutilities.useEventCallback)((event, data)=>{
        setSelectedValue(data.value);
        onTabSelect === null || onTabSelect === void 0 ? void 0 : onTabSelect(event, data);
    });
    const registeredTabs = _react.useRef({});
    const onRegister = (0, _reactutilities.useEventCallback)((data)=>{
        const key = JSON.stringify(data.value);
        if (!key && process.env.NODE_ENV !== 'production') {
            // eslint-disable-next-line no-console
            console.error([
                `[@fluentui/react-tabs] The value "${data.value}" cannot be serialized to JSON string.`,
                'Tab component requires serializable values.',
                'Please provide a primitive value (string, number, boolean),',
                `or a plain object/array that doesn't contain functions, symbols, or circular references.`
            ].join(' '));
        }
        registeredTabs.current[key] = data;
    });
    const onUnregister = (0, _reactutilities.useEventCallback)((data)=>{
        delete registeredTabs.current[JSON.stringify(data.value)];
    });
    const getRegisteredTabs = _react.useCallback(()=>{
        return {
            selectedValue: currentSelectedValue.current,
            previousSelectedValue: previousSelectedValue.current,
            registeredTabs: registeredTabs.current
        };
    }, []);
    return {
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, innerRef),
            role: 'tablist',
            'aria-orientation': vertical ? 'vertical' : 'horizontal',
            ...focusAttributes,
            ...props
        }), {
            elementType: 'div'
        }),
        appearance,
        reserveSelectedTabSpace,
        disabled,
        selectTabOnFocus,
        selectedValue,
        size,
        vertical,
        onRegister,
        onUnregister,
        onSelect,
        getRegisteredTabs
    };
};
