'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tabClassNames: function() {
        return tabClassNames;
    },
    tabReservedSpaceClassNames: function() {
        return tabReservedSpaceClassNames;
    },
    useTabButtonStyles_unstable: function() {
        return useTabButtonStyles_unstable;
    },
    useTabContentStyles_unstable: function() {
        return useTabContentStyles_unstable;
    },
    useTabIndicatorStyles_unstable: function() {
        return useTabIndicatorStyles_unstable;
    },
    useTabStyles_unstable: function() {
        return useTabStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const _useTabAnimatedIndicatorstyles = require("./useTabAnimatedIndicator.styles");
const tabClassNames = {
    root: 'fui-Tab',
    icon: 'fui-Tab__icon',
    content: 'fui-Tab__content'
};
const tabReservedSpaceClassNames = {
    content: 'fui-Tab__content--reserved-space'
};
// These should match the constants defined in @fluentui/react-icons
// This package avoids taking a dependency on the icons package for only the constants.
const iconClassNames = {
    filled: 'fui-Icon-filled',
    regular: 'fui-Icon-regular'
};
/**
 * Styles for the root slot
 */ const useRootStyles = (0, _react.makeStyles)({
    root: {
        alignItems: 'center',
        display: 'grid',
        flexShrink: 0,
        gridAutoFlow: 'column',
        gridTemplateColumns: 'auto',
        gridTemplateRows: 'auto',
        outlineStyle: 'none',
        position: 'relative'
    },
    button: {
        alignItems: 'center',
        border: 'none',
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        cursor: 'pointer',
        display: 'grid',
        flexShrink: 0,
        gridAutoFlow: 'column',
        gridTemplateColumns: 'auto',
        gridTemplateRows: 'auto',
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        lineHeight: _reacttheme.tokens.lineHeightBase300,
        outlineStyle: 'none',
        position: 'relative',
        overflow: 'hidden',
        textTransform: 'none'
    },
    horizontal: {
        justifyContent: 'center'
    },
    vertical: {
        justifyContent: 'start'
    },
    smallHorizontal: {
        columnGap: _reacttheme.tokens.spacingHorizontalXXS,
        padding: `${_reacttheme.tokens.spacingVerticalSNudge} ${_reacttheme.tokens.spacingHorizontalSNudge}`
    },
    smallVertical: {
        // horizontal spacing is deliberate. This is the gap between icon and content.
        columnGap: _reacttheme.tokens.spacingHorizontalXXS,
        padding: `${_reacttheme.tokens.spacingVerticalXXS} ${_reacttheme.tokens.spacingHorizontalSNudge}`
    },
    mediumHorizontal: {
        columnGap: _reacttheme.tokens.spacingHorizontalSNudge,
        padding: `${_reacttheme.tokens.spacingVerticalM} ${_reacttheme.tokens.spacingHorizontalMNudge}`
    },
    mediumVertical: {
        // horizontal spacing is deliberate. This is the gap between icon and content.
        columnGap: _reacttheme.tokens.spacingHorizontalSNudge,
        padding: `${_reacttheme.tokens.spacingVerticalSNudge} ${_reacttheme.tokens.spacingHorizontalMNudge}`
    },
    largeHorizontal: {
        columnGap: _reacttheme.tokens.spacingHorizontalSNudge,
        padding: `${_reacttheme.tokens.spacingVerticalL} ${_reacttheme.tokens.spacingHorizontalMNudge}`
    },
    largeVertical: {
        // horizontal spacing is deliberate. This is the gap between icon and content.
        columnGap: _reacttheme.tokens.spacingHorizontalSNudge,
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalMNudge}`
    },
    transparent: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ':enabled:hover': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundHover
        },
        ':enabled:active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundPressed
        },
        [`& .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2
        },
        [`:enabled:hover .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2Hover
        },
        [`:enabled:active .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2Pressed
        },
        [`& .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2
        },
        [`:enabled:hover .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2Hover
        },
        [`:enabled:active .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2Pressed
        }
    },
    subtle: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        ':enabled:hover': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover
        },
        ':enabled:active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed
        },
        [`& .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2
        },
        [`:enabled:hover .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2Hover
        },
        [`:enabled:active .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2Pressed
        },
        [`& .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2
        },
        [`:enabled:hover .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2Hover
        },
        [`:enabled:active .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground2Pressed
        }
    },
    disabledCursor: {
        cursor: 'not-allowed'
    },
    disabled: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        [`& .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        },
        [`& .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        }
    },
    selected: {
        [`& .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorCompoundBrandForeground1
        },
        [`:enabled:hover .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorCompoundBrandForeground1Hover
        },
        [`:enabled:active .${tabClassNames.icon}`]: {
            color: _reacttheme.tokens.colorCompoundBrandForeground1Pressed
        },
        [`& .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground1
        },
        [`:enabled:hover .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground1Hover
        },
        [`:enabled:active .${tabClassNames.content}`]: {
            color: _reacttheme.tokens.colorNeutralForeground1Pressed
        }
    }
});
const useCircularAppearanceStyles = (0, _react.makeStyles)({
    base: {
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        border: `solid ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorTransparentStroke}`,
        [`& .${tabClassNames.icon}`]: {
            color: 'inherit'
        },
        [`& .${tabClassNames.content}`]: {
            color: 'inherit'
        }
    },
    small: {
        paddingBlock: `calc(${_reacttheme.tokens.spacingVerticalXXS} - ${_reacttheme.tokens.strokeWidthThin})`
    },
    medium: {
        paddingBlock: `calc(${_reacttheme.tokens.spacingVerticalSNudge} - ${_reacttheme.tokens.strokeWidthThin})`
    },
    large: {
        paddingBlock: `calc(${_reacttheme.tokens.spacingVerticalS} - ${_reacttheme.tokens.strokeWidthThin})`
    },
    subtle: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        color: _reacttheme.tokens.colorNeutralForeground2,
        ':enabled:hover': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover,
            border: `solid ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorNeutralStroke1Hover}`,
            color: _reacttheme.tokens.colorNeutralForeground2Hover
        },
        ':enabled:active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed,
            border: `solid ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorNeutralStroke1Pressed}`,
            color: _reacttheme.tokens.colorNeutralForeground2Pressed
        },
        '@media (forced-colors: active)': {
            border: `solid ${_reacttheme.tokens.strokeWidthThin} Canvas`
        }
    },
    subtleSelected: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground2,
        border: `solid ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorCompoundBrandStroke}`,
        color: _reacttheme.tokens.colorBrandForeground2,
        ':enabled:hover': {
            backgroundColor: _reacttheme.tokens.colorBrandBackground2Hover,
            border: `solid ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorCompoundBrandStrokeHover}`,
            color: _reacttheme.tokens.colorBrandForeground2Hover
        },
        ':enabled:active': {
            backgroundColor: _reacttheme.tokens.colorBrandBackground2Pressed,
            border: `solid ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorCompoundBrandStrokePressed}`,
            color: _reacttheme.tokens.colorBrandForeground2Pressed
        },
        '@media (forced-colors: active)': {
            border: `solid ${_reacttheme.tokens.strokeWidthThin} Highlight`
        }
    },
    subtleDisabled: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled
    },
    subtleDisabledSelected: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        border: `solid ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorNeutralStrokeDisabled}`,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled
    },
    filled: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        color: _reacttheme.tokens.colorNeutralForeground2,
        ':enabled:hover': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackground3Hover,
            color: _reacttheme.tokens.colorNeutralForeground2Hover
        },
        ':enabled:active': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackground3Pressed,
            color: _reacttheme.tokens.colorNeutralForeground2Pressed
        },
        '@media (forced-colors: active)': {
            ':enabled:hover': {
                backgroundColor: 'Highlight',
                forcedColorAdjust: 'none',
                [`& .${tabClassNames.content}`]: {
                    color: 'HighlightText'
                },
                [`& .${iconClassNames.filled}`]: {
                    color: 'HighlightText'
                },
                [`& .${iconClassNames.regular}`]: {
                    color: 'HighlightText'
                }
            }
        }
    },
    filledSelected: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand,
        ':enabled:hover': {
            backgroundColor: _reacttheme.tokens.colorBrandBackgroundHover,
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand
        },
        ':enabled:active': {
            backgroundColor: _reacttheme.tokens.colorBrandBackgroundPressed,
            color: _reacttheme.tokens.colorNeutralForegroundOnBrand
        },
        '@media (forced-colors: active)': {
            ':enabled': {
                backgroundColor: 'ButtonText',
                [`& .${tabClassNames.content}`]: {
                    color: 'ButtonFace',
                    forcedColorAdjust: 'none'
                }
            },
            [`:enabled .${tabClassNames.icon}`]: {
                color: 'ButtonFace'
            }
        }
    },
    filledDisabled: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled
    },
    filledDisabledSelected: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
        border: `solid ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorNeutralStrokeDisabled}`,
        color: _reacttheme.tokens.colorNeutralForegroundDisabled
    }
});
/**
 * Focus styles for the root slot
 */ const useFocusStyles = (0, _react.makeStyles)({
    // Tab creates a custom focus indicator because the default focus indicator
    // is applied using an ::after pseudo-element on the root. Since the selection
    // indicator uses an ::after pseudo-element on the root, there is a conflict.
    base: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        ..._react.shorthands.borderColor('transparent'),
        outlineWidth: _reacttheme.tokens.strokeWidthThick,
        outlineColor: 'transparent',
        outlineStyle: 'solid',
        boxShadow: `
      ${_reacttheme.tokens.shadow4},
      0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorStrokeFocus2}
    `,
        zIndex: 1
    }, {
        enableOutline: true
    }),
    circular: (0, _reacttabster.createCustomFocusIndicatorStyle)({
        ..._react.shorthands.borderColor('transparent'),
        outlineWidth: _reacttheme.tokens.strokeWidthThick,
        outlineColor: 'transparent',
        outlineStyle: 'solid',
        boxShadow: `
        ${_reacttheme.tokens.shadow4},
        0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorStrokeFocus2},
        0 0 0 ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorNeutralStrokeOnBrand} inset
      `,
        zIndex: 1
    }, {
        enableOutline: true
    })
});
/** Indicator styles for when pending selection */ const usePendingIndicatorStyles = (0, _react.makeStyles)({
    base: {
        ':hover::before': {
            backgroundColor: _reacttheme.tokens.colorNeutralStroke1Hover,
            borderRadius: _reacttheme.tokens.borderRadiusCircular,
            content: '""',
            position: 'absolute'
        },
        ':active::before': {
            backgroundColor: _reacttheme.tokens.colorNeutralStroke1Pressed,
            borderRadius: _reacttheme.tokens.borderRadiusCircular,
            content: '""',
            position: 'absolute'
        },
        '@media (forced-colors: active)': {
            ':hover::before': {
                backgroundColor: 'Highlight'
            },
            ':active::before': {
                backgroundColor: 'Highlight'
            }
        }
    },
    disabled: {
        ':hover::before': {
            backgroundColor: _reacttheme.tokens.colorTransparentStroke
        },
        ':active::before': {
            backgroundColor: _reacttheme.tokens.colorTransparentStroke
        },
        '@media (forced-colors: active)': {
            ':hover::before': {
                backgroundColor: 'transparent'
            },
            ':active::before': {
                backgroundColor: 'transparent'
            }
        }
    },
    smallHorizontal: {
        '::before': {
            bottom: 0,
            height: _reacttheme.tokens.strokeWidthThick,
            left: _reacttheme.tokens.spacingHorizontalSNudge,
            right: _reacttheme.tokens.spacingHorizontalSNudge
        }
    },
    smallVertical: {
        '::before': {
            bottom: _reacttheme.tokens.spacingVerticalXS,
            left: 0,
            top: _reacttheme.tokens.spacingVerticalXS,
            width: _reacttheme.tokens.strokeWidthThicker
        }
    },
    mediumHorizontal: {
        '::before': {
            bottom: 0,
            height: _reacttheme.tokens.strokeWidthThicker,
            left: _reacttheme.tokens.spacingHorizontalM,
            right: _reacttheme.tokens.spacingHorizontalM
        }
    },
    mediumVertical: {
        '::before': {
            bottom: _reacttheme.tokens.spacingVerticalS,
            left: 0,
            top: _reacttheme.tokens.spacingVerticalS,
            width: _reacttheme.tokens.strokeWidthThicker
        }
    },
    largeHorizontal: {
        '::before': {
            bottom: 0,
            height: _reacttheme.tokens.strokeWidthThicker,
            left: _reacttheme.tokens.spacingHorizontalM,
            right: _reacttheme.tokens.spacingHorizontalM
        }
    },
    largeVertical: {
        '::before': {
            bottom: _reacttheme.tokens.spacingVerticalMNudge,
            left: 0,
            top: _reacttheme.tokens.spacingVerticalMNudge,
            width: _reacttheme.tokens.strokeWidthThicker
        }
    }
});
const useActiveIndicatorStyles = (0, _react.makeStyles)({
    base: {
        '::after': {
            backgroundColor: _reacttheme.tokens.colorTransparentStroke,
            borderRadius: _reacttheme.tokens.borderRadiusCircular,
            content: '""',
            position: 'absolute'
        }
    },
    selected: {
        '::after': {
            backgroundColor: _reacttheme.tokens.colorCompoundBrandStroke
        },
        ':enabled:hover::after': {
            backgroundColor: _reacttheme.tokens.colorCompoundBrandStrokeHover
        },
        ':enabled:active::after': {
            backgroundColor: _reacttheme.tokens.colorCompoundBrandStrokePressed
        },
        '@media (forced-colors: active)': {
            '::after': {
                backgroundColor: 'ButtonText'
            },
            ':enabled:hover::after': {
                backgroundColor: 'ButtonText'
            },
            ':enabled:active::after': {
                backgroundColor: 'ButtonText'
            }
        }
    },
    disabled: {
        '::after': {
            backgroundColor: _reacttheme.tokens.colorNeutralForegroundDisabled
        }
    },
    smallHorizontal: {
        '::after': {
            bottom: 0,
            height: _reacttheme.tokens.strokeWidthThick,
            left: _reacttheme.tokens.spacingHorizontalSNudge,
            right: _reacttheme.tokens.spacingHorizontalSNudge
        }
    },
    smallVertical: {
        '::after': {
            bottom: _reacttheme.tokens.spacingVerticalXS,
            left: '0',
            top: _reacttheme.tokens.spacingVerticalXS,
            width: _reacttheme.tokens.strokeWidthThicker
        }
    },
    mediumHorizontal: {
        '::after': {
            bottom: '0',
            height: _reacttheme.tokens.strokeWidthThicker,
            left: _reacttheme.tokens.spacingHorizontalM,
            right: _reacttheme.tokens.spacingHorizontalM
        }
    },
    mediumVertical: {
        '::after': {
            bottom: _reacttheme.tokens.spacingVerticalS,
            left: 0,
            top: _reacttheme.tokens.spacingVerticalS,
            width: _reacttheme.tokens.strokeWidthThicker
        }
    },
    largeHorizontal: {
        '::after': {
            bottom: 0,
            height: _reacttheme.tokens.strokeWidthThicker,
            left: _reacttheme.tokens.spacingHorizontalM,
            right: _reacttheme.tokens.spacingHorizontalM
        }
    },
    largeVertical: {
        '::after': {
            bottom: _reacttheme.tokens.spacingVerticalMNudge,
            left: 0,
            top: _reacttheme.tokens.spacingVerticalMNudge,
            width: _reacttheme.tokens.strokeWidthThicker
        }
    }
});
/**
 * Styles for the icon slot.
 */ const useIconStyles = (0, _react.makeStyles)({
    base: {
        gridColumnStart: 1,
        gridRowStart: 1,
        alignItems: 'center',
        display: 'inline-flex',
        justifyContent: 'center',
        overflow: 'hidden',
        [`& .${iconClassNames.filled}`]: {
            display: 'none'
        },
        [`& .${iconClassNames.regular}`]: {
            display: 'inline'
        }
    },
    // per design, the small and medium font sizes are the same.
    // the size prop only affects spacing.
    small: {
        fontSize: '20px',
        height: '20px',
        width: '20px'
    },
    medium: {
        fontSize: '20px',
        height: '20px',
        width: '20px'
    },
    large: {
        fontSize: '24px',
        height: '24px',
        width: '24px'
    },
    selected: {
        [`& .${iconClassNames.filled}`]: {
            display: 'inline'
        },
        [`& .${iconClassNames.regular}`]: {
            display: 'none'
        }
    }
});
/**
 * Styles for the content slot (children)
 */ const useContentStyles = (0, _react.makeStyles)({
    base: {
        ..._reacttheme.typographyStyles.body1,
        overflow: 'hidden',
        // content padding is the same for medium & small, horizontal & vertical
        padding: `${_reacttheme.tokens.spacingVerticalNone} ${_reacttheme.tokens.spacingHorizontalXXS}`
    },
    selected: {
        ..._reacttheme.typographyStyles.body1Strong
    },
    large: {
        ..._reacttheme.typographyStyles.body2
    },
    largeSelected: {
        ..._reacttheme.typographyStyles.subtitle2
    },
    noIconBefore: {
        gridColumnStart: 1,
        gridRowStart: 1
    },
    iconBefore: {
        gridColumnStart: 2,
        gridRowStart: 1
    },
    placeholder: {
        visibility: 'hidden'
    }
});
const useTabStyles_unstable = (state)=>{
    'use no memo';
    useTabIndicatorStyles_unstable(state);
    useTabButtonStyles_unstable(state, state.root);
    useTabContentStyles_unstable(state);
    return state;
};
const useTabIndicatorStyles_unstable = (state)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const pendingIndicatorStyles = usePendingIndicatorStyles();
    const activeIndicatorStyles = useActiveIndicatorStyles();
    const { appearance, disabled, selected, size, vertical } = state;
    const classes = [
        tabClassNames.root,
        rootStyles.root
    ];
    if (appearance !== 'subtle-circular' && appearance !== 'filled-circular') {
        classes.push(pendingIndicatorStyles.base, size === 'small' && (vertical ? pendingIndicatorStyles.smallVertical : pendingIndicatorStyles.smallHorizontal), size === 'medium' && (vertical ? pendingIndicatorStyles.mediumVertical : pendingIndicatorStyles.mediumHorizontal), size === 'large' && (vertical ? pendingIndicatorStyles.largeVertical : pendingIndicatorStyles.largeHorizontal), disabled && pendingIndicatorStyles.disabled, selected && activeIndicatorStyles.base, selected && !disabled && activeIndicatorStyles.selected, selected && size === 'small' && (vertical ? activeIndicatorStyles.smallVertical : activeIndicatorStyles.smallHorizontal), selected && size === 'medium' && (vertical ? activeIndicatorStyles.mediumVertical : activeIndicatorStyles.mediumHorizontal), selected && size === 'large' && (vertical ? activeIndicatorStyles.largeVertical : activeIndicatorStyles.largeHorizontal), selected && disabled && activeIndicatorStyles.disabled);
    }
    state.root.className = (0, _react.mergeClasses)(...classes, state.root.className);
    (0, _useTabAnimatedIndicatorstyles.useTabAnimatedIndicatorStyles_unstable)(state);
    return state;
};
const useTabButtonStyles_unstable = (state, slot)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const focusStyles = useFocusStyles();
    const circularStyles = useCircularAppearanceStyles();
    const { appearance, disabled, selected, size, vertical } = state;
    const isSubtleCircular = appearance === 'subtle-circular';
    const isFilledCircular = appearance === 'filled-circular';
    const isCircular = isSubtleCircular || isFilledCircular;
    const circularAppearance = [
        circularStyles.base,
        focusStyles.circular,
        // sizes
        size === 'small' && circularStyles.small,
        size === 'medium' && circularStyles.medium,
        size === 'large' && circularStyles.large,
        // subtle-circular appearance
        isSubtleCircular && circularStyles.subtle,
        selected && isSubtleCircular && circularStyles.subtleSelected,
        disabled && isSubtleCircular && circularStyles.subtleDisabled,
        selected && disabled && isSubtleCircular && circularStyles.subtleDisabledSelected,
        // filled-circular appearance
        isFilledCircular && circularStyles.filled,
        selected && isFilledCircular && circularStyles.filledSelected,
        disabled && isFilledCircular && circularStyles.filledDisabled,
        selected && disabled && isFilledCircular && circularStyles.filledDisabledSelected
    ];
    const regularAppearance = [
        focusStyles.base,
        !disabled && appearance === 'subtle' && rootStyles.subtle,
        !disabled && appearance === 'transparent' && rootStyles.transparent,
        !disabled && selected && rootStyles.selected,
        disabled && rootStyles.disabled
    ];
    slot.className = (0, _react.mergeClasses)(rootStyles.button, vertical ? rootStyles.vertical : rootStyles.horizontal, size === 'small' && (vertical ? rootStyles.smallVertical : rootStyles.smallHorizontal), size === 'medium' && (vertical ? rootStyles.mediumVertical : rootStyles.mediumHorizontal), size === 'large' && (vertical ? rootStyles.largeVertical : rootStyles.largeHorizontal), ...isCircular ? circularAppearance : regularAppearance, disabled && rootStyles.disabledCursor, slot.className);
    return state;
};
const useTabContentStyles_unstable = (state)=>{
    'use no memo';
    const iconStyles = useIconStyles();
    const contentStyles = useContentStyles();
    const { selected, size } = state;
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(tabClassNames.icon, iconStyles.base, iconStyles[size], selected && iconStyles.selected, state.icon.className);
    }
    // This needs to be before state.content.className is updated
    if (state.contentReservedSpace) {
        state.contentReservedSpace.className = (0, _react.mergeClasses)(tabReservedSpaceClassNames.content, contentStyles.base, size === 'large' ? contentStyles.largeSelected : contentStyles.selected, state.icon ? contentStyles.iconBefore : contentStyles.noIconBefore, contentStyles.placeholder, state.content.className);
        // FIXME: this is a deprecated API
        // should be removed in the next major version
        // eslint-disable-next-line @typescript-eslint/no-deprecated
        state.contentReservedSpaceClassName = state.contentReservedSpace.className;
    }
    state.content.className = (0, _react.mergeClasses)(tabClassNames.content, contentStyles.base, size === 'large' && contentStyles.large, selected && (size === 'large' ? contentStyles.largeSelected : contentStyles.selected), state.icon ? contentStyles.iconBefore : contentStyles.noIconBefore, state.content.className);
    return state;
};
