'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTab_unstable", {
    enumerable: true,
    get: function() {
        return useTab_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const _TabListContext = require("../TabList/TabListContext");
const useTab_unstable = (props, ref)=>{
    const { content, disabled: tabDisabled = false, icon, onClick, onFocus, value } = props;
    const appearance = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.appearance);
    const reserveSelectedTabSpace = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.reserveSelectedTabSpace);
    const selectTabOnFocus = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.selectTabOnFocus);
    const listDisabled = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.disabled);
    const selected = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.selectedValue === value);
    const onRegister = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.onRegister);
    const onUnregister = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.onUnregister);
    const onSelect = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.onSelect);
    const size = (0, _TabListContext.useTabListContext_unstable)((ctx)=>ctx.size);
    const vertical = (0, _TabListContext.useTabListContext_unstable)((ctx)=>!!ctx.vertical);
    const disabled = listDisabled || tabDisabled;
    const innerRef = _react.useRef(null);
    const onSelectCallback = (event)=>onSelect(event, {
            value
        });
    const onTabClick = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(onClick, onSelectCallback));
    const onTabFocus = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(onFocus, onSelectCallback));
    const focusProps = (0, _reacttabster.useTabsterAttributes)({
        focusable: {
            isDefault: selected
        }
    });
    _react.useEffect(()=>{
        onRegister({
            value,
            ref: innerRef
        });
        return ()=>{
            onUnregister({
                value,
                ref: innerRef
            });
        };
    }, [
        onRegister,
        onUnregister,
        innerRef,
        value
    ]);
    const iconSlot = _reactutilities.slot.optional(icon, {
        elementType: 'span'
    });
    const contentSlot = _reactutilities.slot.always(content, {
        defaultProps: {
            children: props.children
        },
        elementType: 'span'
    });
    const contentReservedSpace = content && typeof content === 'object' ? (0, _reactutilities.omit)(content, [
        'ref'
    ]) : content;
    const iconOnly = Boolean((iconSlot === null || iconSlot === void 0 ? void 0 : iconSlot.children) && !contentSlot.children);
    return {
        components: {
            root: 'button',
            icon: 'span',
            content: 'span',
            contentReservedSpace: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('button', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLButtonElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, innerRef),
            role: 'tab',
            type: 'button',
            // aria-selected undefined indicates it is not selectable
            // according to https://www.w3.org/TR/wai-aria-1.1/#aria-selected
            'aria-selected': disabled ? undefined : `${selected}`,
            ...focusProps,
            ...props,
            disabled,
            onClick: onTabClick,
            onFocus: selectTabOnFocus ? onTabFocus : onFocus
        }), {
            elementType: 'button'
        }),
        icon: iconSlot,
        iconOnly,
        content: contentSlot,
        contentReservedSpace: _reactutilities.slot.optional(contentReservedSpace, {
            renderByDefault: !selected && !iconOnly && reserveSelectedTabSpace,
            defaultProps: {
                children: props.children
            },
            elementType: 'span'
        }),
        appearance,
        disabled,
        selected,
        size,
        value,
        vertical
    };
};
