'use client';
import * as React from 'react';
import { useControllableState, useEventCallback } from '@fluentui/react-utilities';
const noop = ()=>undefined;
export const defaultTableSortState = {
    getSortDirection: ()=>'ascending',
    setColumnSort: noop,
    sort: (rows)=>[
            ...rows
        ],
    sortColumn: undefined,
    sortDirection: 'ascending',
    toggleColumnSort: noop
};
export function useTableSort(options) {
    'use no memo';
    // False positive, these plugin hooks are intended to be run on every render
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return (tableState)=>useTableSortState(tableState, options);
}
export function useTableSortState(tableState, options) {
    const { columns } = tableState;
    const { sortState, defaultSortState, onSortChange: onSortChangeProp = noop } = options;
    const [sorted, setSorted] = useControllableState({
        initialState: {
            sortDirection: 'ascending',
            sortColumn: undefined
        },
        defaultState: defaultSortState,
        state: sortState
    });
    const { sortColumn, sortDirection } = sorted;
    const onSortChange = useEventCallback(onSortChangeProp);
    const toggleColumnSort = React.useCallback((e, columnId)=>{
        setSorted((s)=>{
            const newState = {
                ...s,
                sortColumn: columnId
            };
            if (s.sortColumn === columnId) {
                newState.sortDirection = s.sortDirection === 'ascending' ? 'descending' : 'ascending';
            } else {
                newState.sortDirection = 'ascending';
            }
            onSortChange === null || onSortChange === void 0 ? void 0 : onSortChange(e, newState);
            return newState;
        });
    }, [
        onSortChange,
        setSorted
    ]);
    const setColumnSort = (e, nextSortColumn, nextSortDirection)=>{
        const newState = {
            sortColumn: nextSortColumn,
            sortDirection: nextSortDirection
        };
        onSortChange === null || onSortChange === void 0 ? void 0 : onSortChange(e, newState);
        setSorted(newState);
    };
    const sort = React.useCallback((rows)=>{
        return rows.slice().sort((a, b)=>{
            const sortColumnDef = columns.find((column)=>column.columnId === sortColumn);
            if (!(sortColumnDef === null || sortColumnDef === void 0 ? void 0 : sortColumnDef.compare)) {
                return 0;
            }
            const mod = sortDirection === 'ascending' ? 1 : -1;
            return sortColumnDef.compare(a.item, b.item) * mod;
        });
    }, [
        columns,
        sortColumn,
        sortDirection
    ]);
    const getSortDirection = (columnId)=>{
        return sortColumn === columnId ? sortDirection : undefined;
    };
    return {
        ...tableState,
        sort: {
            sort,
            sortColumn,
            sortDirection,
            setColumnSort,
            toggleColumnSort,
            getSortDirection
        }
    };
}
