'use client';
import * as React from 'react';
import { useEventCallback, useSelection } from '@fluentui/react-utilities';
const noop = ()=>undefined;
export const defaultTableSelectionState = {
    allRowsSelected: false,
    clearRows: noop,
    deselectRow: noop,
    isRowSelected: ()=>false,
    selectRow: noop,
    selectedRows: new Set(),
    someRowsSelected: false,
    toggleAllRows: noop,
    toggleRow: noop,
    selectionMode: 'multiselect'
};
export function useTableSelection(options) {
    'use no memo';
    // False positive, these plugin hooks are intended to be run on every render
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return (tableState)=>useTableSelectionState(tableState, options);
}
export function useTableSelectionState(tableState, options) {
    const { items, getRowId } = tableState;
    const { selectionMode: selectionMode, defaultSelectedItems, selectedItems, onSelectionChange } = options;
    const [selected, selectionMethods] = useSelection({
        selectionMode,
        defaultSelectedItems,
        selectedItems,
        onSelectionChange
    });
    // Selection state can contain obselete items (i.e. rows that are removed)
    const selectableRowIds = React.useMemo(()=>{
        const rowIds = new Set();
        for(let i = 0; i < items.length; i++){
            var _getRowId;
            rowIds.add((_getRowId = getRowId === null || getRowId === void 0 ? void 0 : getRowId(items[i])) !== null && _getRowId !== void 0 ? _getRowId : i);
        }
        return rowIds;
    }, [
        items,
        getRowId
    ]);
    const allRowsSelected = React.useMemo(()=>{
        if (selectionMode === 'single') {
            const selectedRow = Array.from(selected)[0];
            return selectableRowIds.has(selectedRow);
        }
        // multiselect case
        if (selected.size < selectableRowIds.size) {
            return false;
        }
        if (selectableRowIds.size === 0) {
            return false;
        }
        let res = true;
        selectableRowIds.forEach((selectableRowId)=>{
            if (!selected.has(selectableRowId)) {
                res = false;
            }
        });
        return res;
    }, [
        selectableRowIds,
        selected,
        selectionMode
    ]);
    const someRowsSelected = React.useMemo(()=>{
        if (selected.size <= 0) {
            return false;
        }
        let res = false;
        selectableRowIds.forEach((selectableRowId)=>{
            if (selected.has(selectableRowId)) {
                res = true;
            }
        });
        return res;
    }, [
        selectableRowIds,
        selected
    ]);
    const toggleAllRows = useEventCallback((e)=>{
        selectionMethods.toggleAllItems(e, items.map((item, i)=>{
            var _getRowId;
            return (_getRowId = getRowId === null || getRowId === void 0 ? void 0 : getRowId(item)) !== null && _getRowId !== void 0 ? _getRowId : i;
        }));
    });
    const toggleRow = useEventCallback((e, rowId)=>selectionMethods.toggleItem(e, rowId));
    const deselectRow = useEventCallback((e, rowId)=>selectionMethods.deselectItem(e, rowId));
    const selectRow = useEventCallback((e, rowId)=>selectionMethods.selectItem(e, rowId));
    const isRowSelected = (rowId)=>selectionMethods.isSelected(rowId);
    const clearRows = useEventCallback((e)=>selectionMethods.clearItems(e));
    return {
        ...tableState,
        selection: {
            selectionMode,
            someRowsSelected,
            allRowsSelected,
            selectedRows: selected,
            toggleRow,
            toggleAllRows,
            clearRows,
            deselectRow,
            selectRow,
            isRowSelected
        }
    };
}
