'use client';
import * as React from 'react';
import { defaultTableSelectionState } from './useTableSelection';
import { defaultTableSortState } from './useTableSort';
import { defaultColumnSizingState } from './useTableColumnSizing';
const defaultRowEnhancer = (row)=>row;
export const defaultTableState = {
    selection: defaultTableSelectionState,
    sort: defaultTableSortState,
    getRows: ()=>[],
    getRowId: ()=>'',
    items: [],
    columns: [],
    // eslint-disable-next-line @typescript-eslint/naming-convention
    columnSizing_unstable: defaultColumnSizingState,
    tableRef: React.createRef()
};
export function useTableFeatures(options, plugins = []) {
    const { items, getRowId, columns } = options;
    const getRows = React.useCallback((rowEnhancer = defaultRowEnhancer)=>{
        return items.map((item, i)=>{
            var _getRowId;
            return rowEnhancer({
                item,
                rowId: (_getRowId = getRowId === null || getRowId === void 0 ? void 0 : getRowId(item)) !== null && _getRowId !== void 0 ? _getRowId : i
            });
        });
    }, [
        items,
        getRowId
    ]);
    const initialState = {
        getRowId,
        items,
        columns,
        getRows,
        selection: defaultTableSelectionState,
        sort: defaultTableSortState,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        columnSizing_unstable: defaultColumnSizingState,
        tableRef: React.createRef()
    };
    return plugins.reduce((state, plugin)=>plugin(state), initialState);
}
