'use client';
import { makeStyles, mergeClasses, shorthands } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { tableCellActionsClassNames } from '../TableCellActions/useTableCellActionsStyles.styles';
import { tableSelectionCellClassNames } from '../TableSelectionCell/useTableSelectionCellStyles.styles';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
export const tableRowClassName = 'fui-TableRow';
export const tableRowClassNames = {
    root: tableRowClassName
};
const useTableLayoutStyles = makeStyles({
    root: {
        display: 'table-row'
    }
});
const useFlexLayoutStyles = makeStyles({
    root: {
        display: 'flex',
        alignItems: 'center'
    }
});
/**
 * Styles for the root slot
 */ const useStyles = makeStyles({
    root: {
        color: tokens.colorNeutralForeground1,
        boxSizing: 'border-box',
        ...createCustomFocusIndicatorStyle({
            [`& .${tableSelectionCellClassNames.root}`]: {
                opacity: 1
            },
            [`& .${tableCellActionsClassNames.root}`]: {
                opacity: 1
            }
        }, {
            selector: 'focus-within'
        }),
        ...createCustomFocusIndicatorStyle({
            outline: `2px solid ${tokens.colorStrokeFocus2}`,
            borderRadius: tokens.borderRadiusMedium
        }, {
            selector: 'focus'
        })
    },
    rootInteractive: {
        ...createCustomFocusIndicatorStyle({
            [`& .${tableCellActionsClassNames.root}`]: {
                opacity: 1
            }
        }, {
            selector: 'focus-within'
        }),
        ':active': {
            backgroundColor: tokens.colorSubtleBackgroundPressed,
            color: tokens.colorNeutralForeground1Pressed,
            [`& .${tableCellActionsClassNames.root}`]: {
                opacity: 1
            },
            [`& .${tableSelectionCellClassNames.root}`]: {
                opacity: 1
            }
        },
        ':hover': {
            backgroundColor: tokens.colorSubtleBackgroundHover,
            color: tokens.colorNeutralForeground1Hover,
            [`& .${tableCellActionsClassNames.root}`]: {
                opacity: 1
            },
            [`& .${tableSelectionCellClassNames.root}`]: {
                opacity: 1
            }
        },
        // High contrast styles
        '@media (forced-colors: active)': {
            ':hover': {
                color: 'Highlight',
                ...shorthands.borderColor('Highlight')
            }
        }
    },
    medium: {
        borderBottom: `${tokens.strokeWidthThin} solid ${tokens.colorNeutralStroke2}`
    },
    small: {
        borderBottom: `${tokens.strokeWidthThin} solid ${tokens.colorNeutralStroke2}`
    },
    'extra-small': {
        fontSize: tokens.fontSizeBase200
    },
    brand: {
        backgroundColor: tokens.colorBrandBackground2,
        ...shorthands.borderColor(tokens.colorTransparentStrokeInteractive),
        ':active': {
            backgroundColor: tokens.colorBrandBackground2,
            color: tokens.colorNeutralForeground1
        },
        '@media(forced-colors: active)': {
            border: '2px solid transparent',
            borderRadius: tokens.borderRadiusMedium,
            boxSizing: 'border-box',
            ':focus-visible': {
                outlineOffset: '-4px'
            }
        }
    },
    neutral: {
        '@media(forced-colors: active)': {
            border: '2px solid transparent',
            borderRadius: tokens.borderRadiusMedium,
            boxSizing: 'border-box',
            ':focus-visible': {
                outlineOffset: '-4px'
            }
        },
        backgroundColor: tokens.colorSubtleBackgroundSelected,
        color: tokens.colorNeutralForeground1Hover,
        ':hover': {
            backgroundColor: tokens.colorSubtleBackgroundSelected
        },
        ':active': {
            backgroundColor: tokens.colorSubtleBackgroundSelected
        },
        ...shorthands.borderColor(tokens.colorNeutralStrokeOnBrand)
    },
    none: {}
});
/**
 * Apply styling to the TableRow slots based on the state
 */ export const useTableRowStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const layoutStyles = {
        table: useTableLayoutStyles(),
        flex: useFlexLayoutStyles()
    };
    state.root.className = mergeClasses(tableRowClassNames.root, styles.root, !state.isHeaderRow && styles.rootInteractive, styles[state.size], state.noNativeElements ? layoutStyles.flex.root : layoutStyles.table.root, styles[state.appearance], state.root.className);
    return state;
};
