'use client';

import { __styles, mergeClasses, shorthands } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { tableCellActionsClassNames } from '../TableCellActions/useTableCellActionsStyles.styles';
import { tableSelectionCellClassNames } from '../TableSelectionCell/useTableSelectionCellStyles.styles';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
export const tableRowClassName = 'fui-TableRow';
export const tableRowClassNames = {
  root: tableRowClassName
};
const useTableLayoutStyles = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "f1u0rzck"
  }
}, {
  d: [".f1u0rzck{display:table-row;}"]
});
const useFlexLayoutStyles = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "f22iagw",
    Bt984gj: "f122n59"
  }
}, {
  d: [".f22iagw{display:flex;}", ".f122n59{align-items:center;}"]
});
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  root: {
    sj55zd: "f19n0e5",
    B7ck84d: "f1ewtqcl",
    Bconypa: "f1jazu75",
    B6guboy: "f1xeqee6",
    Bfpq7zp: 0,
    g9k6zt: 0,
    Bn4voq9: 0,
    giviqs: "f1dxfoyt",
    Bw81rd7: 0,
    kdpuga: 0,
    dm238s: 0,
    B6xbmo0: 0,
    B3whbx2: "f2krc9w"
  },
  rootInteractive: {
    B6guboy: "f1xeqee6",
    ecr2s2: "f1wfn5kd",
    lj723h: "f1g4hkjv",
    B43xm9u: "f15ngxrw",
    i921ia: "fjbbrdp",
    Jwef8y: "f1t94bn6",
    Bi91k9c: "feu1g3u",
    Bpt6rm4: "f1uorfem",
    ff6mpl: "fw60kww",
    ze5xyy: "f4xjyn1",
    pgvf35: "ff1wgvm",
    Bh7lczh: ["fiob0tu", "f1x4h75k"],
    dpv3f4: "f1j6scgf",
    Bpnjhaq: ["f1x4h75k", "fiob0tu"]
  },
  medium: {
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    Bgfg5da: "f1facbz3"
  },
  small: {
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    Bgfg5da: "f1facbz3"
  },
  "extra-small": {
    Be2twd7: "fy9rknc"
  },
  brand: {
    De3pzq: "f16xkysk",
    g2u3we: "f1bh3yvw",
    h3c5rm: ["fmi79ni", "f11fozsx"],
    B9xav0g: "fnzw4c6",
    zhjwy3: ["f11fozsx", "fmi79ni"],
    ecr2s2: "f7tkmfy",
    lj723h: "f1r2dosr",
    uu68id: 0,
    Bxeuatn: 0,
    felo30: 0,
    Bc736ss: 0,
    Bhz882k: 0,
    n51gp8: 0,
    Eshu5l: 0,
    Bk6ri7n: 0,
    v49c4f: 0,
    Bn1d65q: 0,
    c4eypz: 0,
    v3aym: 0,
    hft9gk: 0,
    Bjwas2f: 0,
    Bk5ld8o: 0,
    gwxt9v: 0,
    B6k8go: "f95l9gw",
    h6lo6r: 0,
    Beo2b4z: 0,
    w1pwid: 0,
    Btyw6ap: 0,
    Hkxhyr: "fw8kmcu",
    Brwvgy3: "fd94n53",
    yadkgm: "f1e0wld5"
  },
  neutral: {
    uu68id: 0,
    Bxeuatn: 0,
    felo30: 0,
    Bc736ss: 0,
    Bhz882k: 0,
    n51gp8: 0,
    Eshu5l: 0,
    Bk6ri7n: 0,
    v49c4f: 0,
    Bn1d65q: 0,
    c4eypz: 0,
    v3aym: 0,
    hft9gk: 0,
    Bjwas2f: 0,
    Bk5ld8o: 0,
    gwxt9v: 0,
    B6k8go: "f95l9gw",
    h6lo6r: 0,
    Beo2b4z: 0,
    w1pwid: 0,
    Btyw6ap: 0,
    Hkxhyr: "fw8kmcu",
    Brwvgy3: "fd94n53",
    yadkgm: "f1e0wld5",
    De3pzq: "fq5gl1p",
    sj55zd: "f1cgsbmv",
    Jwef8y: "f1uqaxdt",
    ecr2s2: "fa9o754",
    g2u3we: "frmsihh",
    h3c5rm: ["frttxa5", "f11o2r7f"],
    B9xav0g: "fem5et0",
    zhjwy3: ["f11o2r7f", "frttxa5"]
  },
  none: {}
}, {
  d: [".f19n0e5{color:var(--colorNeutralForeground1);}", ".f1ewtqcl{box-sizing:border-box;}", ".f1jazu75[data-fui-focus-within]:focus-within .fui-TableSelectionCell{opacity:1;}", ".f1xeqee6[data-fui-focus-within]:focus-within .fui-TableCellActions{opacity:1;}", [".f1dxfoyt[data-fui-focus-visible]{outline:2px solid var(--colorStrokeFocus2);}", {
    p: -1
  }], [".f2krc9w[data-fui-focus-visible]{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f1facbz3{border-bottom:var(--strokeWidthThin) solid var(--colorNeutralStroke2);}", {
    p: -1
  }], [".f1facbz3{border-bottom:var(--strokeWidthThin) solid var(--colorNeutralStroke2);}", {
    p: -1
  }], ".fy9rknc{font-size:var(--fontSizeBase200);}", ".f16xkysk{background-color:var(--colorBrandBackground2);}", ".f1bh3yvw{border-top-color:var(--colorTransparentStrokeInteractive);}", ".fmi79ni{border-right-color:var(--colorTransparentStrokeInteractive);}", ".f11fozsx{border-left-color:var(--colorTransparentStrokeInteractive);}", ".fnzw4c6{border-bottom-color:var(--colorTransparentStrokeInteractive);}", ".fq5gl1p{background-color:var(--colorSubtleBackgroundSelected);}", ".f1cgsbmv{color:var(--colorNeutralForeground1Hover);}", ".frmsihh{border-top-color:var(--colorNeutralStrokeOnBrand);}", ".frttxa5{border-right-color:var(--colorNeutralStrokeOnBrand);}", ".f11o2r7f{border-left-color:var(--colorNeutralStrokeOnBrand);}", ".fem5et0{border-bottom-color:var(--colorNeutralStrokeOnBrand);}"],
  a: [".f1wfn5kd:active{background-color:var(--colorSubtleBackgroundPressed);}", ".f1g4hkjv:active{color:var(--colorNeutralForeground1Pressed);}", ".f15ngxrw:active .fui-TableCellActions{opacity:1;}", ".fjbbrdp:active .fui-TableSelectionCell{opacity:1;}", ".f7tkmfy:active{background-color:var(--colorBrandBackground2);}", ".f1r2dosr:active{color:var(--colorNeutralForeground1);}", ".fa9o754:active{background-color:var(--colorSubtleBackgroundSelected);}"],
  h: [".f1t94bn6:hover{background-color:var(--colorSubtleBackgroundHover);}", ".feu1g3u:hover{color:var(--colorNeutralForeground1Hover);}", ".f1uorfem:hover .fui-TableCellActions{opacity:1;}", ".fw60kww:hover .fui-TableSelectionCell{opacity:1;}", ".f1uqaxdt:hover{background-color:var(--colorSubtleBackgroundSelected);}"],
  m: [["@media (forced-colors: active){.f4xjyn1:hover{color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.ff1wgvm:hover{border-top-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1x4h75k:hover{border-left-color:Highlight;}.fiob0tu:hover{border-right-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1j6scgf:hover{border-bottom-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f95l9gw{border:2px solid transparent;}}", {
    p: -2,
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.fw8kmcu{border-radius:var(--borderRadiusMedium);}}", {
    p: -1,
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.fd94n53{box-sizing:border-box;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1e0wld5:focus-visible{outline-offset:-4px;}}", {
    m: "(forced-colors: active)"
  }]]
});
/**
 * Apply styling to the TableRow slots based on the state
 */
export const useTableRowStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const layoutStyles = {
    table: useTableLayoutStyles(),
    flex: useFlexLayoutStyles()
  };
  state.root.className = mergeClasses(tableRowClassNames.root, styles.root, !state.isHeaderRow && styles.rootInteractive, styles[state.size], state.noNativeElements ? layoutStyles.flex.root : layoutStyles.table.root, styles[state.appearance], state.root.className);
  return state;
};