'use client';
import * as React from 'react';
import { getIntrinsicElementProps, useMergedRefs, slot } from '@fluentui/react-utilities';
import { useFocusVisible, useFocusWithin } from '@fluentui/react-tabster';
import { useTableContext } from '../../contexts/tableContext';
import { useIsInTableHeader } from '../../contexts/tableHeaderContext';
/**
 * Create the state required to render TableRow.
 *
 * The returned state can be modified with hooks such as useTableRowStyles_unstable,
 * before being passed to renderTableRow_unstable.
 *
 * @param props - props from this instance of TableRow
 * @param ref - reference to root HTMLElement of TableRow
 */ export const useTableRow_unstable = (props, ref)=>{
    const { noNativeElements, size } = useTableContext();
    var _props_as;
    const rootComponent = ((_props_as = props.as) !== null && _props_as !== void 0 ? _props_as : noNativeElements) ? 'div' : 'tr';
    const focusVisibleRef = useFocusVisible();
    const focusWithinRef = useFocusWithin();
    const isHeaderRow = useIsInTableHeader();
    var _props_appearance;
    return {
        components: {
            root: rootComponent
        },
        root: slot.always(getIntrinsicElementProps(rootComponent, {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: useMergedRefs(ref, focusVisibleRef, focusWithinRef),
            role: rootComponent === 'div' ? 'row' : undefined,
            ...props
        }), {
            elementType: rootComponent
        }),
        size,
        noNativeElements,
        appearance: (_props_appearance = props.appearance) !== null && _props_appearance !== void 0 ? _props_appearance : 'none',
        isHeaderRow
    };
};
