'use client';
import * as React from 'react';
import { getIntrinsicElementProps, slot } from '@fluentui/react-utilities';
import { useTableContext } from '../../contexts/tableContext';
/**
 * Create the state required to render TableHeader.
 *
 * The returned state can be modified with hooks such as useTableHeaderStyles_unstable,
 * before being passed to renderTableHeader_unstable.
 *
 * @param props - props from this instance of TableHeader
 * @param ref - reference to root HTMLElement of TableHeader
 */ export const useTableHeader_unstable = (props, ref)=>{
    const { noNativeElements } = useTableContext();
    var _props_as;
    const rootComponent = ((_props_as = props.as) !== null && _props_as !== void 0 ? _props_as : noNativeElements) ? 'div' : 'thead';
    return {
        components: {
            root: rootComponent
        },
        root: slot.always(getIntrinsicElementProps(rootComponent, {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref,
            role: rootComponent === 'div' ? 'rowgroup' : undefined,
            ...props
        }), {
            elementType: rootComponent
        }),
        noNativeElements
    };
};
