'use client';
import * as React from 'react';
import { getIntrinsicElementProps, slot } from '@fluentui/react-utilities';
import { useTableContext } from '../../contexts/tableContext';
/**
 * Create the state required to render TableCell.
 *
 * The returned state can be modified with hooks such as useTableCellStyles_unstable,
 * before being passed to renderTableCell_unstable.
 *
 * @param props - props from this instance of TableCell
 * @param ref - reference to root HTMLElement of TableCell
 */ export const useTableCell_unstable = (props, ref)=>{
    const { noNativeElements, size } = useTableContext();
    var _props_as;
    const rootComponent = ((_props_as = props.as) !== null && _props_as !== void 0 ? _props_as : noNativeElements) ? 'div' : 'td';
    return {
        components: {
            root: rootComponent
        },
        root: slot.always(getIntrinsicElementProps(rootComponent, {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref,
            role: rootComponent === 'div' ? 'cell' : undefined,
            ...props
        }), {
            elementType: rootComponent
        }),
        noNativeElements,
        size
    };
};
