'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
export const tableClassName = 'fui-Table';
export const tableClassNames = {
  root: 'fui-Table'
};
const useTableLayoutStyles = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "f1w4nmp0",
    ha4doy: "fmrv4ls",
    a9b677: "fly5x3f",
    B73mfa3: "f14m3nip"
  }
}, {
  d: [".f1w4nmp0{display:table;}", ".fmrv4ls{vertical-align:middle;}", ".fly5x3f{width:100%;}", ".f14m3nip{table-layout:fixed;}"]
});
const useFlexLayoutStyles = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "ftgm304"
  }
}, {
  d: [".ftgm304{display:block;}"]
});
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  root: {
    po53p8: "fgkb47j",
    De3pzq: "fhovq9v"
  }
}, {
  d: [".fgkb47j{border-collapse:collapse;}", ".fhovq9v{background-color:var(--colorSubtleBackground);}"]
});
/**
 * Apply styling to the Table slots based on the state
 */
export const useTableStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const layoutStyles = {
    table: useTableLayoutStyles(),
    flex: useFlexLayoutStyles()
  };
  state.root.className = mergeClasses(tableClassName, styles.root, state.noNativeElements ? layoutStyles.flex.root : layoutStyles.table.root, state.root.className);
  return state;
};