'use client';
import * as React from 'react';
import { useFocusableGroup } from '@fluentui/react-tabster';
import { useEventCallback } from '@fluentui/react-utilities';
import { useTableHeaderCell_unstable } from '../TableHeaderCell/useTableHeaderCell';
import { useDataGridContext_unstable } from '../../contexts/dataGridContext';
import { useColumnIdContext } from '../../contexts/columnIdContext';
import { useTableContext } from '../../contexts/tableContext';
import { isColumnSortable } from '../../utils/isColumnSortable';
/**
 * Create the state required to render DataGridHeaderCell.
 *
 * The returned state can be modified with hooks such as useDataGridHeaderCellStyles_unstable,
 * before being passed to renderDataGridHeaderCell_unstable.
 *
 * @param props - props from this instance of DataGridHeaderCell
 * @param ref - reference to root HTMLElement of DataGridHeaderCell
 */ export const useDataGridHeaderCell_unstable = (props, ref)=>{
    const columnId = useColumnIdContext();
    const { sortable: gridSortable } = useTableContext();
    const toggleColumnSort = useDataGridContext_unstable((ctx)=>ctx.sort.toggleColumnSort);
    const sortable = useDataGridContext_unstable((ctx)=>{
        const columnSortable = !!ctx.columns.find((c)=>c.columnId === columnId && isColumnSortable(c));
        if (!gridSortable) {
            // if the grid is not sortable - disable sorting on all columns
            return false;
        }
        return columnSortable;
    });
    const sortDirection = useDataGridContext_unstable((ctx)=>sortable ? ctx.sort.getSortDirection(columnId) : undefined);
    const resizableColumns = useDataGridContext_unstable((ctx)=>ctx.resizableColumns);
    const getTableHeaderCellProps = useDataGridContext_unstable((ctx)=>{
        return ctx.columnSizing_unstable.getTableHeaderCellProps;
    });
    const { focusMode = sortable ? 'none' : 'cell' } = props;
    const focusableGroupAttr = useFocusableGroup({
        tabBehavior: 'limited-trap-focus'
    });
    // eslint-disable-next-line @typescript-eslint/no-deprecated -- prefer HTMLTableCellElement
    const onClick = useEventCallback((e)=>{
        var _props_onClick;
        if (sortable) {
            toggleColumnSort(e, columnId);
        }
        (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, e);
    });
    return useTableHeaderCell_unstable({
        sortable,
        sortDirection,
        as: 'div',
        tabIndex: focusMode !== 'none' ? 0 : undefined,
        ...focusMode === 'group' && focusableGroupAttr,
        ...resizableColumns ? getTableHeaderCellProps(columnId) : {},
        ...props,
        onClick
    }, ref);
};
