'use client';
import * as React from 'react';
import { useArrowNavigationGroup, useFocusFinders } from '@fluentui/react-tabster';
import { useTable_unstable } from '../Table/useTable';
import { useEventCallback, useMergedRefs } from '@fluentui/react-utilities';
import { End, Home } from '@fluentui/keyboard-keys';
import { useTableFeatures, useTableSort, useTableSelection, useTableColumnSizing_unstable, useTableCompositeNavigation } from '../../hooks';
import { CELL_WIDTH } from '../TableSelectionCell';
/**
 * Create the state required to render DataGrid.
 *
 * The returned state can be modified with hooks such as useDataGridStyles_unstable,
 * before being passed to renderDataGrid_unstable.
 *
 * @param props - props from this instance of DataGrid
 * @param ref - reference to root HTMLElement of DataGrid
 */ export const useDataGrid_unstable = (props, ref)=>{
    const { items, columns, focusMode = 'cell', selectionMode, onSortChange, onSelectionChange, defaultSortState, sortState, selectedItems, defaultSelectedItems, subtleSelection = false, selectionAppearance = 'brand', getRowId, resizableColumns, columnSizingOptions, onColumnResize, containerWidthOffset, resizableColumnsOptions = {} } = props;
    const widthOffset = containerWidthOffset !== null && containerWidthOffset !== void 0 ? containerWidthOffset : selectionMode ? -CELL_WIDTH : 0;
    const gridTabsterAttribute = useArrowNavigationGroup({
        axis: 'grid'
    });
    const { onTableKeyDown: onCompositeKeyDown, tableTabsterAttribute: compositeTabsterAttribute, tableRowTabsterAttribute: compositeRowTabsterAttribute } = useTableCompositeNavigation();
    var _resizableColumnsOptions_autoFitColumns;
    const tableState = useTableFeatures({
        items,
        columns,
        getRowId
    }, [
        useTableSort({
            defaultSortState,
            sortState,
            onSortChange
        }),
        useTableSelection({
            defaultSelectedItems,
            selectedItems,
            onSelectionChange,
            selectionMode: selectionMode !== null && selectionMode !== void 0 ? selectionMode : 'multiselect'
        }),
        useTableColumnSizing_unstable({
            onColumnResize,
            columnSizingOptions,
            // The selection cell is not part of the columns, therefore its width needs to be subtracted
            // from the container to make sure the columns don't overflow the table.
            containerWidthOffset: widthOffset,
            // Disables automatic resizing of columns when the container overflows.
            // This allows the sum of the columns to be larger than the container.
            autoFitColumns: (_resizableColumnsOptions_autoFitColumns = resizableColumnsOptions.autoFitColumns) !== null && _resizableColumnsOptions_autoFitColumns !== void 0 ? _resizableColumnsOptions_autoFitColumns : true
        })
    ]);
    const innerRef = React.useRef(null);
    const { findFirstFocusable, findLastFocusable } = useFocusFinders();
    const onKeyDown = useEventCallback((e)=>{
        var _props_onKeyDown;
        (_props_onKeyDown = props.onKeyDown) === null || _props_onKeyDown === void 0 ? void 0 : _props_onKeyDown.call(props, e);
        focusMode === 'composite' && onCompositeKeyDown(e);
        // handle ctrl+home and ctrl+end
        if (!innerRef.current || !e.ctrlKey || e.defaultPrevented) {
            return;
        }
        if (e.key === Home) {
            const firstRow = innerRef.current.querySelector('[role="row"]');
            if (firstRow) {
                var _findFirstFocusable;
                (_findFirstFocusable = findFirstFocusable(firstRow)) === null || _findFirstFocusable === void 0 ? void 0 : _findFirstFocusable.focus();
            }
        }
        if (e.key === End) {
            const rows = innerRef.current.querySelectorAll('[role="row"]');
            if (rows.length) {
                var _findLastFocusable;
                const lastRow = rows.item(rows.length - 1);
                (_findLastFocusable = findLastFocusable(lastRow)) === null || _findLastFocusable === void 0 ? void 0 : _findLastFocusable.focus();
            }
        }
    });
    const baseTableState = useTable_unstable({
        role: 'grid',
        as: 'div',
        noNativeElements: true,
        ...focusMode === 'cell' && gridTabsterAttribute,
        ...focusMode === 'composite' && compositeTabsterAttribute,
        ...props,
        onKeyDown,
        ...resizableColumns ? tableState.columnSizing_unstable.getTableProps(props) : {}
    }, useMergedRefs(ref, tableState.tableRef, innerRef));
    return {
        ...baseTableState,
        focusMode,
        tableState,
        selectableRows: !!selectionMode,
        subtleSelection,
        selectionAppearance,
        resizableColumns,
        compositeRowTabsterAttribute
    };
};
