'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    defaultTableSortState: function() {
        return defaultTableSortState;
    },
    useTableSort: function() {
        return useTableSort;
    },
    useTableSortState: function() {
        return useTableSortState;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const noop = ()=>undefined;
const defaultTableSortState = {
    getSortDirection: ()=>'ascending',
    setColumnSort: noop,
    sort: (rows)=>[
            ...rows
        ],
    sortColumn: undefined,
    sortDirection: 'ascending',
    toggleColumnSort: noop
};
function useTableSort(options) {
    'use no memo';
    // False positive, these plugin hooks are intended to be run on every render
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return (tableState)=>useTableSortState(tableState, options);
}
function useTableSortState(tableState, options) {
    const { columns } = tableState;
    const { sortState, defaultSortState, onSortChange: onSortChangeProp = noop } = options;
    const [sorted, setSorted] = (0, _reactutilities.useControllableState)({
        initialState: {
            sortDirection: 'ascending',
            sortColumn: undefined
        },
        defaultState: defaultSortState,
        state: sortState
    });
    const { sortColumn, sortDirection } = sorted;
    const onSortChange = (0, _reactutilities.useEventCallback)(onSortChangeProp);
    const toggleColumnSort = _react.useCallback((e, columnId)=>{
        setSorted((s)=>{
            const newState = {
                ...s,
                sortColumn: columnId
            };
            if (s.sortColumn === columnId) {
                newState.sortDirection = s.sortDirection === 'ascending' ? 'descending' : 'ascending';
            } else {
                newState.sortDirection = 'ascending';
            }
            onSortChange === null || onSortChange === void 0 ? void 0 : onSortChange(e, newState);
            return newState;
        });
    }, [
        onSortChange,
        setSorted
    ]);
    const setColumnSort = (e, nextSortColumn, nextSortDirection)=>{
        const newState = {
            sortColumn: nextSortColumn,
            sortDirection: nextSortDirection
        };
        onSortChange === null || onSortChange === void 0 ? void 0 : onSortChange(e, newState);
        setSorted(newState);
    };
    const sort = _react.useCallback((rows)=>{
        return rows.slice().sort((a, b)=>{
            const sortColumnDef = columns.find((column)=>column.columnId === sortColumn);
            if (!(sortColumnDef === null || sortColumnDef === void 0 ? void 0 : sortColumnDef.compare)) {
                return 0;
            }
            const mod = sortDirection === 'ascending' ? 1 : -1;
            return sortColumnDef.compare(a.item, b.item) * mod;
        });
    }, [
        columns,
        sortColumn,
        sortDirection
    ]);
    const getSortDirection = (columnId)=>{
        return sortColumn === columnId ? sortDirection : undefined;
    };
    return {
        ...tableState,
        sort: {
            sort,
            sortColumn,
            sortDirection,
            setColumnSort,
            toggleColumnSort,
            getSortDirection
        }
    };
}
