'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    defaultTableSelectionState: function() {
        return defaultTableSelectionState;
    },
    useTableSelection: function() {
        return useTableSelection;
    },
    useTableSelectionState: function() {
        return useTableSelectionState;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const noop = ()=>undefined;
const defaultTableSelectionState = {
    allRowsSelected: false,
    clearRows: noop,
    deselectRow: noop,
    isRowSelected: ()=>false,
    selectRow: noop,
    selectedRows: new Set(),
    someRowsSelected: false,
    toggleAllRows: noop,
    toggleRow: noop,
    selectionMode: 'multiselect'
};
function useTableSelection(options) {
    'use no memo';
    // False positive, these plugin hooks are intended to be run on every render
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return (tableState)=>useTableSelectionState(tableState, options);
}
function useTableSelectionState(tableState, options) {
    const { items, getRowId } = tableState;
    const { selectionMode: selectionMode, defaultSelectedItems, selectedItems, onSelectionChange } = options;
    const [selected, selectionMethods] = (0, _reactutilities.useSelection)({
        selectionMode,
        defaultSelectedItems,
        selectedItems,
        onSelectionChange
    });
    // Selection state can contain obselete items (i.e. rows that are removed)
    const selectableRowIds = _react.useMemo(()=>{
        const rowIds = new Set();
        for(let i = 0; i < items.length; i++){
            var _getRowId;
            rowIds.add((_getRowId = getRowId === null || getRowId === void 0 ? void 0 : getRowId(items[i])) !== null && _getRowId !== void 0 ? _getRowId : i);
        }
        return rowIds;
    }, [
        items,
        getRowId
    ]);
    const allRowsSelected = _react.useMemo(()=>{
        if (selectionMode === 'single') {
            const selectedRow = Array.from(selected)[0];
            return selectableRowIds.has(selectedRow);
        }
        // multiselect case
        if (selected.size < selectableRowIds.size) {
            return false;
        }
        if (selectableRowIds.size === 0) {
            return false;
        }
        let res = true;
        selectableRowIds.forEach((selectableRowId)=>{
            if (!selected.has(selectableRowId)) {
                res = false;
            }
        });
        return res;
    }, [
        selectableRowIds,
        selected,
        selectionMode
    ]);
    const someRowsSelected = _react.useMemo(()=>{
        if (selected.size <= 0) {
            return false;
        }
        let res = false;
        selectableRowIds.forEach((selectableRowId)=>{
            if (selected.has(selectableRowId)) {
                res = true;
            }
        });
        return res;
    }, [
        selectableRowIds,
        selected
    ]);
    const toggleAllRows = (0, _reactutilities.useEventCallback)((e)=>{
        selectionMethods.toggleAllItems(e, items.map((item, i)=>{
            var _getRowId;
            return (_getRowId = getRowId === null || getRowId === void 0 ? void 0 : getRowId(item)) !== null && _getRowId !== void 0 ? _getRowId : i;
        }));
    });
    const toggleRow = (0, _reactutilities.useEventCallback)((e, rowId)=>selectionMethods.toggleItem(e, rowId));
    const deselectRow = (0, _reactutilities.useEventCallback)((e, rowId)=>selectionMethods.deselectItem(e, rowId));
    const selectRow = (0, _reactutilities.useEventCallback)((e, rowId)=>selectionMethods.selectItem(e, rowId));
    const isRowSelected = (rowId)=>selectionMethods.isSelected(rowId);
    const clearRows = (0, _reactutilities.useEventCallback)((e)=>selectionMethods.clearItems(e));
    return {
        ...tableState,
        selection: {
            selectionMode,
            someRowsSelected,
            allRowsSelected,
            selectedRows: selected,
            toggleRow,
            toggleAllRows,
            clearRows,
            deselectRow,
            selectRow,
            isRowSelected
        }
    };
}
