'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    defaultTableState: function() {
        return defaultTableState;
    },
    useTableFeatures: function() {
        return useTableFeatures;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useTableSelection = require("./useTableSelection");
const _useTableSort = require("./useTableSort");
const _useTableColumnSizing = require("./useTableColumnSizing");
const defaultRowEnhancer = (row)=>row;
const defaultTableState = {
    selection: _useTableSelection.defaultTableSelectionState,
    sort: _useTableSort.defaultTableSortState,
    getRows: ()=>[],
    getRowId: ()=>'',
    items: [],
    columns: [],
    // eslint-disable-next-line @typescript-eslint/naming-convention
    columnSizing_unstable: _useTableColumnSizing.defaultColumnSizingState,
    tableRef: /*#__PURE__*/ _react.createRef()
};
function useTableFeatures(options, plugins = []) {
    const { items, getRowId, columns } = options;
    const getRows = _react.useCallback((rowEnhancer = defaultRowEnhancer)=>{
        return items.map((item, i)=>{
            var _getRowId;
            return rowEnhancer({
                item,
                rowId: (_getRowId = getRowId === null || getRowId === void 0 ? void 0 : getRowId(item)) !== null && _getRowId !== void 0 ? _getRowId : i
            });
        });
    }, [
        items,
        getRowId
    ]);
    const initialState = {
        getRowId,
        items,
        columns,
        getRows,
        selection: _useTableSelection.defaultTableSelectionState,
        sort: _useTableSort.defaultTableSortState,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        columnSizing_unstable: _useTableColumnSizing.defaultColumnSizingState,
        tableRef: /*#__PURE__*/ _react.createRef()
    };
    return plugins.reduce((state, plugin)=>plugin(state), initialState);
}
