'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTableCompositeNavigation", {
    enumerable: true,
    get: function() {
        return useTableCompositeNavigation;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
function useTableCompositeNavigation() {
    const horizontalAttr = (0, _reacttabster.useArrowNavigationGroup)({
        axis: 'horizontal'
    });
    const gridAttr = (0, _reacttabster.useArrowNavigationGroup)({
        axis: 'grid'
    });
    const groupperAttr = (0, _reacttabster.useFocusableGroup)({
        tabBehavior: 'limited-trap-focus'
    });
    const { findFirstFocusable } = (0, _reacttabster.useFocusFinders)();
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const rowAttr = (0, _reacttabster.useMergedTabsterAttributes_unstable)(horizontalAttr, groupperAttr);
    const onKeyDown = _react.useCallback((e)=>{
        if (!targetDocument) {
            return;
        }
        let activeElement = targetDocument.activeElement;
        if (!activeElement || !e.currentTarget.contains(activeElement)) {
            return;
        }
        const activeElementRole = activeElement.getAttribute('role');
        // Enter groupper when in row focus mode to navigate cells
        if (e.key === _keyboardkeys.ArrowRight && activeElementRole === 'row' && (0, _reactutilities.isHTMLElement)(activeElement)) {
            var _findFirstFocusable;
            (_findFirstFocusable = findFirstFocusable(activeElement)) === null || _findFirstFocusable === void 0 ? void 0 : _findFirstFocusable.focus();
        }
        if (activeElementRole === 'row') {
            return;
        }
        const isInCell = (()=>{
            let cur = (0, _reactutilities.isHTMLElement)(activeElement) ? activeElement : null;
            while(cur){
                const curRole = cur.getAttribute('role');
                if (curRole === 'cell' || curRole === 'gridcell') {
                    return true;
                }
                cur = cur.parentElement;
            }
            return false;
        })();
        // Escape groupper focus trap before arrow left, arrow down or arrow up
        if (e.key === _keyboardkeys.ArrowLeft && isInCell) {
            activeElement.dispatchEvent(new _reacttabster.GroupperMoveFocusEvent({
                action: _reacttabster.GroupperMoveFocusActions.Escape
            }));
            return;
        }
        if ((e.key === _keyboardkeys.ArrowDown || e.key === _keyboardkeys.ArrowUp) && isInCell) {
            activeElement.dispatchEvent(new _reacttabster.GroupperMoveFocusEvent({
                action: _reacttabster.GroupperMoveFocusActions.Escape
            }));
            activeElement = targetDocument.activeElement;
            if (activeElement) {
                activeElement.dispatchEvent(new _reacttabster.MoverMoveFocusEvent({
                    key: _reacttabster.MoverKeys[e.key]
                }));
            }
        }
    }, [
        targetDocument,
        findFirstFocusable
    ]);
    return {
        onTableKeyDown: onKeyDown,
        tableTabsterAttribute: gridAttr,
        tableRowTabsterAttribute: rowAttr
    };
}
