'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    defaultColumnSizingState: function() {
        return defaultColumnSizingState;
    },
    useTableColumnSizing_unstable: function() {
        return useTableColumnSizing_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _TableResizeHandle = require("../TableResizeHandle");
const _useMeasureElement = require("./useMeasureElement");
const _useTableColumnResizeMouseHandler = require("./useTableColumnResizeMouseHandler");
const _useTableColumnResizeState = require("./useTableColumnResizeState");
const _useKeyboardResizing = require("./useKeyboardResizing");
const defaultColumnSizingState = {
    getColumnWidths: ()=>[],
    getOnMouseDown: ()=>()=>null,
    setColumnWidth: ()=>null,
    getTableProps: ()=>({}),
    getTableHeaderCellProps: ()=>({
            style: {},
            columnId: ''
        }),
    getTableCellProps: ()=>({
            style: {},
            columnId: ''
        }),
    enableKeyboardMode: ()=>()=>null
};
function useTableColumnSizing_unstable(params) {
    'use no memo';
    // False positive, these plugin hooks are intended to be run on every render
    return (tableState)=>useTableColumnSizingState(tableState, {
            autoFitColumns: true,
            ...params
        });
}
function getColumnStyles(column, dragging) {
    const width = column.width;
    return {
        // native styles
        width,
        // non-native element styles (flex layout)
        minWidth: width,
        maxWidth: width,
        // Fixed the unwanted sort: https://github.com/microsoft/fluentui/issues/27803
        ...dragging ? {
            pointerEvents: 'none'
        } : {}
    };
}
function useTableColumnSizingState(tableState, params = {}) {
    const { columns } = tableState;
    // Gets the container width
    const { width, measureElementRef } = (0, _useMeasureElement.useMeasureElement)();
    // Creates the state based on columns and available containerWidth
    const columnResizeState = (0, _useTableColumnResizeState.useTableColumnResizeState)(columns, width + ((params === null || params === void 0 ? void 0 : params.containerWidthOffset) || 0), params);
    // Creates the mouse handler and attaches the state to it
    const mouseHandler = (0, _useTableColumnResizeMouseHandler.useTableColumnResizeMouseHandler)(columnResizeState);
    // Creates the keyboard handler for resizing columns
    const { toggleInteractiveMode, getKeyboardResizingProps } = (0, _useKeyboardResizing.useKeyboardResizing)(columnResizeState);
    const { autoFitColumns } = params;
    const enableKeyboardMode = _react.useCallback((columnId, onChange)=>(e)=>{
            e.preventDefault();
            e.nativeEvent.stopPropagation();
            toggleInteractiveMode(columnId, onChange);
        }, [
        toggleInteractiveMode
    ]);
    const { getColumnById, setColumnWidth, getColumns } = columnResizeState;
    const { getOnMouseDown, dragging } = mouseHandler;
    return {
        ...tableState,
        tableRef: measureElementRef,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        columnSizing_unstable: {
            getOnMouseDown,
            setColumnWidth: (columnId, w)=>setColumnWidth(undefined, {
                    columnId,
                    width: w
                }),
            getColumnWidths: getColumns,
            getTableProps: (props = {})=>{
                return {
                    ...props,
                    style: {
                        minWidth: 'fit-content',
                        ...props.style || {}
                    }
                };
            },
            getTableHeaderCellProps: _react.useCallback((columnId)=>{
                var _columns_;
                const col = getColumnById(columnId);
                const isLastColumn = ((_columns_ = columns[columns.length - 1]) === null || _columns_ === void 0 ? void 0 : _columns_.columnId) === columnId;
                const aside = isLastColumn && autoFitColumns ? null : /*#__PURE__*/ _react.createElement(_TableResizeHandle.TableResizeHandle, {
                    onMouseDown: getOnMouseDown(columnId),
                    onTouchStart: getOnMouseDown(columnId),
                    ...getKeyboardResizingProps(columnId, (col === null || col === void 0 ? void 0 : col.width) || 0)
                });
                return col ? {
                    style: getColumnStyles(col, dragging),
                    aside
                } : {};
            }, [
                getColumnById,
                columns,
                dragging,
                getKeyboardResizingProps,
                getOnMouseDown,
                autoFitColumns
            ]),
            getTableCellProps: _react.useCallback((columnId)=>{
                const col = getColumnById(columnId);
                return col ? {
                    style: getColumnStyles(col)
                } : {};
            }, [
                getColumnById
            ]),
            enableKeyboardMode
        }
    };
}
