'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTableColumnResizeState", {
    enumerable: true,
    get: function() {
        return useTableColumnResizeState;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _columnResizeUtils = require("../utils/columnResizeUtils");
const createReducer = (autoFitColumns)=>(state, action)=>{
        switch(action.type){
            case 'CONTAINER_WIDTH_UPDATED':
                return {
                    ...state,
                    containerWidth: action.containerWidth,
                    columnWidthState: autoFitColumns ? (0, _columnResizeUtils.adjustColumnWidthsToFitContainer)(state.columnWidthState, action.containerWidth) : state.columnWidthState
                };
            case 'COLUMNS_UPDATED':
                const newS = (0, _columnResizeUtils.columnDefinitionsToState)(action.columns, state.columnWidthState, state.columnSizingOptions);
                return {
                    ...state,
                    columns: action.columns,
                    columnWidthState: autoFitColumns ? (0, _columnResizeUtils.adjustColumnWidthsToFitContainer)(newS, state.containerWidth) : newS
                };
            case 'COLUMN_SIZING_OPTIONS_UPDATED':
                const newState = (0, _columnResizeUtils.columnDefinitionsToState)(state.columns, state.columnWidthState, action.columnSizingOptions);
                return {
                    ...state,
                    columnSizingOptions: action.columnSizingOptions,
                    columnWidthState: autoFitColumns ? (0, _columnResizeUtils.adjustColumnWidthsToFitContainer)(newState, state.containerWidth) : newState
                };
            case 'SET_COLUMN_WIDTH':
                const { columnId, width } = action;
                const { containerWidth } = state;
                const column = (0, _columnResizeUtils.getColumnById)(state.columnWidthState, columnId);
                let newColumnWidthState = [
                    ...state.columnWidthState
                ];
                if (!column) {
                    return state;
                }
                // Adjust the column width and measure the new total width
                newColumnWidthState = (0, _columnResizeUtils.setColumnProperty)(newColumnWidthState, columnId, 'width', width);
                // Set this width as idealWidth, because its a deliberate change, not a recalculation because of container
                newColumnWidthState = (0, _columnResizeUtils.setColumnProperty)(newColumnWidthState, columnId, 'idealWidth', width);
                // Adjust the widths to the container size
                if (autoFitColumns) {
                    newColumnWidthState = (0, _columnResizeUtils.adjustColumnWidthsToFitContainer)(newColumnWidthState, containerWidth);
                }
                return {
                    ...state,
                    columnWidthState: newColumnWidthState
                };
        }
    };
function useTableColumnResizeState(columns, containerWidth, params = {}) {
    const { onColumnResize, columnSizingOptions, autoFitColumns = true } = params;
    const reducer = _react.useMemo(()=>createReducer(autoFitColumns), [
        autoFitColumns
    ]);
    const [state, dispatch] = _react.useReducer(reducer, {
        columns,
        containerWidth: 0,
        columnWidthState: (0, _columnResizeUtils.columnDefinitionsToState)(columns, undefined, columnSizingOptions),
        columnSizingOptions
    });
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        dispatch({
            type: 'CONTAINER_WIDTH_UPDATED',
            containerWidth
        });
    }, [
        containerWidth
    ]);
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        dispatch({
            type: 'COLUMNS_UPDATED',
            columns
        });
    }, [
        columns
    ]);
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        dispatch({
            type: 'COLUMN_SIZING_OPTIONS_UPDATED',
            columnSizingOptions
        });
    }, [
        columnSizingOptions
    ]);
    const setColumnWidth = (0, _reactutilities.useEventCallback)((event, data)=>{
        let { width } = data;
        const { columnId } = data;
        const col = (0, _columnResizeUtils.getColumnById)(state.columnWidthState, columnId);
        if (!col) {
            return;
        }
        width = Math.max(col.minWidth || 0, width);
        if (onColumnResize) {
            onColumnResize(event, {
                columnId,
                width
            });
        }
        dispatch({
            type: 'SET_COLUMN_WIDTH',
            columnId,
            width
        });
    });
    return {
        getColumnById: _react.useCallback((colId)=>(0, _columnResizeUtils.getColumnById)(state.columnWidthState, colId), [
            state.columnWidthState
        ]),
        getColumns: _react.useCallback(()=>state.columnWidthState, [
            state.columnWidthState
        ]),
        getColumnWidth: _react.useCallback((colId)=>(0, _columnResizeUtils.getColumnWidth)(state.columnWidthState, colId), [
            state.columnWidthState
        ]),
        setColumnWidth
    };
}
