'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTableColumnResizeMouseHandler", {
    enumerable: true,
    get: function() {
        return useTableColumnResizeMouseHandler;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reactutilities = require("@fluentui/react-utilities");
function useTableColumnResizeMouseHandler(columnResizeState) {
    const mouseX = _react.useRef(0);
    const currentWidth = _react.useRef(0);
    const colId = _react.useRef(undefined);
    const [dragging, setDragging] = _react.useState(false);
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const { getColumnWidth, setColumnWidth } = columnResizeState;
    const recalculatePosition = _react.useCallback((e)=>{
        const { clientX } = (0, _reactutilities.getEventClientCoords)(e);
        const dx = clientX - mouseX.current;
        // Update the local width for the column and set it
        currentWidth.current += dx;
        colId.current && setColumnWidth(e, {
            columnId: colId.current,
            width: currentWidth.current
        });
        mouseX.current = clientX;
    }, [
        setColumnWidth
    ]);
    const [requestRecalcFrame] = (0, _reactutilities.useAnimationFrame)();
    const onDrag = _react.useCallback((e)=>{
        // Using requestAnimationFrame here drastically improves resizing experience on slower CPUs
        requestRecalcFrame(()=>recalculatePosition(e));
    }, [
        requestRecalcFrame,
        recalculatePosition
    ]);
    const onDragEnd = _react.useCallback((event)=>{
        if ((0, _reactutilities.isMouseEvent)(event)) {
            targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.removeEventListener('mouseup', onDragEnd);
            targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.removeEventListener('mousemove', onDrag);
        }
        if ((0, _reactutilities.isTouchEvent)(event)) {
            targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.removeEventListener('touchend', onDragEnd);
            targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.removeEventListener('touchmove', onDrag);
        }
        setDragging(false);
    }, [
        onDrag,
        targetDocument
    ]);
    const getOnMouseDown = _react.useCallback((columnId)=>(event)=>{
            // Keep the width locally so that we decouple the calculation of the next with from rendering.
            // This makes the whole experience much faster and more precise
            currentWidth.current = getColumnWidth(columnId);
            mouseX.current = (0, _reactutilities.getEventClientCoords)(event).clientX;
            colId.current = columnId;
            if ((0, _reactutilities.isMouseEvent)(event)) {
                // ignore other buttons than primary mouse button
                if (event.target !== event.currentTarget || event.button !== 0) {
                    return;
                }
                targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.addEventListener('mouseup', onDragEnd);
                targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.addEventListener('mousemove', onDrag);
                setDragging(true);
            }
            if ((0, _reactutilities.isTouchEvent)(event)) {
                targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.addEventListener('touchend', onDragEnd);
                targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.addEventListener('touchmove', onDrag);
                setDragging(true);
            }
        }, [
        getColumnWidth,
        onDrag,
        onDragEnd,
        targetDocument
    ]);
    return {
        getOnMouseDown,
        dragging
    };
}
