'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createResizeObserverFromDocument: function() {
        return createResizeObserverFromDocument;
    },
    useMeasureElement: function() {
        return useMeasureElement;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
function useMeasureElement() {
    const [width, setWidth] = _react.useState(0);
    const container = _react.useRef(undefined);
    const resizeObserverRef = _react.useRef(null);
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    // the handler for resize observer
    const handleResize = _react.useCallback(()=>{
        var _container_current;
        const containerWidth = (_container_current = container.current) === null || _container_current === void 0 ? void 0 : _container_current.getBoundingClientRect().width;
        setWidth(containerWidth || 0);
    }, []);
    const measureElementRef = _react.useCallback((el)=>{
        if (!targetDocument) {
            return;
        }
        // if the element is removed, stop observing it
        if (!el && resizeObserverRef.current && container.current) {
            resizeObserverRef.current.unobserve(container.current);
        }
        container.current = undefined;
        if (el === null || el === void 0 ? void 0 : el.parentElement) {
            var _resizeObserverRef_current;
            container.current = el.parentElement;
            handleResize();
            (_resizeObserverRef_current = resizeObserverRef.current) === null || _resizeObserverRef_current === void 0 ? void 0 : _resizeObserverRef_current.observe(container.current);
        }
    }, [
        targetDocument,
        handleResize
    ]);
    _react.useEffect(()=>{
        resizeObserverRef.current = createResizeObserverFromDocument(targetDocument, handleResize);
        if (!container.current || !resizeObserverRef.current) {
            return;
        }
        resizeObserverRef.current.observe(container.current);
        return ()=>{
            var _resizeObserverRef_current;
            (_resizeObserverRef_current = resizeObserverRef.current) === null || _resizeObserverRef_current === void 0 ? void 0 : _resizeObserverRef_current.disconnect();
        };
    }, [
        handleResize,
        targetDocument
    ]);
    return {
        width,
        measureElementRef
    };
}
function createResizeObserverFromDocument(targetDocument, callback) {
    var _targetDocument_defaultView;
    if (!(targetDocument === null || targetDocument === void 0 ? void 0 : (_targetDocument_defaultView = targetDocument.defaultView) === null || _targetDocument_defaultView === void 0 ? void 0 : _targetDocument_defaultView.ResizeObserver)) {
        return null;
    }
    return new targetDocument.defaultView.ResizeObserver(callback);
}
