'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useKeyboardResizing", {
    enumerable: true,
    get: function() {
        return useKeyboardResizing;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const STEP = 20;
const PRECISION_MODIFIER = _keyboardkeys.Shift;
const PRECISION_FACTOR = 1 / 4;
function useKeyboardResizing(columnResizeState) {
    const [columnId, setColumnId] = _react.useState();
    const onChangeRef = _react.useRef(undefined);
    const { findPrevFocusable } = (0, _reacttabster.useFocusFinders)();
    const columnResizeStateRef = _react.useRef(columnResizeState);
    _react.useEffect(()=>{
        columnResizeStateRef.current = columnResizeState;
    }, [
        columnResizeState
    ]);
    const [resizeHandleRefs] = _react.useState(()=>new Map());
    const keyboardHandler = (0, _reactutilities.useEventCallback)((event)=>{
        if (!columnId) {
            return;
        }
        const width = columnResizeStateRef.current.getColumnWidth(columnId);
        const precisionModifier = event.getModifierState(PRECISION_MODIFIER);
        const stopEvent = ()=>{
            event.preventDefault();
            event.stopPropagation();
        };
        switch(event.key){
            case _keyboardkeys.ArrowLeft:
                stopEvent();
                columnResizeStateRef.current.setColumnWidth(event.nativeEvent, {
                    columnId,
                    width: width - (precisionModifier ? STEP * PRECISION_FACTOR : STEP)
                });
                return;
            case _keyboardkeys.ArrowRight:
                stopEvent();
                columnResizeStateRef.current.setColumnWidth(event.nativeEvent, {
                    columnId,
                    width: width + (precisionModifier ? STEP * PRECISION_FACTOR : STEP)
                });
                return;
            case _keyboardkeys.Space:
            case _keyboardkeys.Enter:
            case _keyboardkeys.Escape:
                var _resizeHandleRefs_get_current, _resizeHandleRefs_get;
                stopEvent();
                (_resizeHandleRefs_get = resizeHandleRefs.get(columnId)) === null || _resizeHandleRefs_get === void 0 ? void 0 : (_resizeHandleRefs_get_current = _resizeHandleRefs_get.current) === null || _resizeHandleRefs_get_current === void 0 ? void 0 : _resizeHandleRefs_get_current.blur();
                break;
        }
    });
    const enableInteractiveMode = _react.useCallback((colId)=>{
        var _onChangeRef_current, _resizeHandleRefs_get;
        setColumnId(colId);
        (_onChangeRef_current = onChangeRef.current) === null || _onChangeRef_current === void 0 ? void 0 : _onChangeRef_current.call(onChangeRef, colId, true);
        const handle = (_resizeHandleRefs_get = resizeHandleRefs.get(colId)) === null || _resizeHandleRefs_get === void 0 ? void 0 : _resizeHandleRefs_get.current;
        if (handle) {
            handle.setAttribute('tabindex', '-1');
            handle.tabIndex = -1;
            handle.focus();
        }
    }, [
        resizeHandleRefs
    ]);
    const disableInteractiveMode = _react.useCallback(()=>{
        var _onChangeRef_current, _resizeHandleRefs_get;
        if (!columnId) {
            return;
        }
        (_onChangeRef_current = onChangeRef.current) === null || _onChangeRef_current === void 0 ? void 0 : _onChangeRef_current.call(onChangeRef, columnId, false);
        // Find the previous focusable element (table header button) and focus it.
        const el = (_resizeHandleRefs_get = resizeHandleRefs.get(columnId)) === null || _resizeHandleRefs_get === void 0 ? void 0 : _resizeHandleRefs_get.current;
        if (el) {
            var _findPrevFocusable;
            (_findPrevFocusable = findPrevFocusable(el)) === null || _findPrevFocusable === void 0 ? void 0 : _findPrevFocusable.focus(); // Focus the previous focusable element (header button).
            el.removeAttribute('tabindex');
        }
        setColumnId(undefined);
    }, [
        columnId,
        findPrevFocusable,
        resizeHandleRefs
    ]);
    const toggleInteractiveMode = (colId, onChange)=>{
        onChangeRef.current = onChange;
        if (!columnId) {
            enableInteractiveMode(colId);
        } else if (colId && columnId !== colId) {
            enableInteractiveMode(colId);
            setColumnId(colId);
        } else {
            disableInteractiveMode();
        }
    };
    const getKeyboardResizingRef = _react.useCallback((colId)=>{
        const ref = resizeHandleRefs.get(colId) || /*#__PURE__*/ _react.createRef();
        resizeHandleRefs.set(colId, ref);
        return ref;
    }, [
        resizeHandleRefs
    ]);
    // This makes sure the left and right arrow keys are ignored in tabster,
    // so that they can be used for resizing.
    const tabsterAttrs = (0, _reacttabster.useTabsterAttributes)({
        focusable: {
            ignoreKeydown: {
                ArrowLeft: true,
                ArrowRight: true
            }
        }
    });
    return {
        toggleInteractiveMode,
        columnId,
        getKeyboardResizingProps: _react.useCallback((colId, currentWidth)=>({
                onKeyDown: keyboardHandler,
                onBlur: disableInteractiveMode,
                ref: getKeyboardResizingRef(colId),
                role: 'separator',
                'aria-label': 'Resize column',
                'aria-valuetext': `${currentWidth} pixels`,
                'aria-hidden': colId === columnId ? false : true,
                tabIndex: colId === columnId ? 0 : undefined,
                ...tabsterAttrs
            }), [
            columnId,
            disableInteractiveMode,
            getKeyboardResizingRef,
            keyboardHandler,
            tabsterAttrs
        ])
    };
}
